/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.Serializable;
import org.kohsuke.stapler.export.Exported;

public class CvsFile
implements Serializable {
    private static final long serialVersionUID = -3429721308650490782L;
    private static final Interner<CvsFile> INTERNER = Interners.newWeakInterner();
    private final String name;
    private final String revision;
    private final boolean dead;

    public static CvsFile make(String name, String revision) {
        return CvsFile.make(name, revision, false);
    }

    public static CvsFile make(String name, String revision, boolean isDead) {
        return (CvsFile)INTERNER.intern((Object)new CvsFile(name, revision, isDead));
    }

    private CvsFile(String name, String revision, boolean isDead) {
        this.name = name;
        this.revision = revision.intern();
        this.dead = isDead;
    }

    private Object readResolve() {
        return INTERNER.intern((Object)this);
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public String getRevision() {
        return this.revision;
    }

    @Exported
    public boolean isDead() {
        return this.dead;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dead ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CvsFile other = (CvsFile)obj;
        if (this.dead != other.dead) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }
}

