/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.impl;

import com.cloudbees.plugins.credentials.BaseCredentials;
import com.cloudbees.plugins.credentials.ContextInPath;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSelectHelper;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.util.FormValidation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class BaseStandardCredentials
extends BaseCredentials
implements StandardCredentials {
    @NonNull
    private final String id;
    @NonNull
    private final String description;

    public BaseStandardCredentials(@CheckForNull String id, @CheckForNull String description) {
        this.id = IdCredentials.Helpers.fixEmptyId(id);
        this.description = Util.fixNull((String)description);
    }

    public BaseStandardCredentials(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description) {
        super(scope);
        this.id = IdCredentials.Helpers.fixEmptyId(id);
        this.description = Util.fixNull((String)description);
    }

    @Override
    @Exported
    @NonNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @Exported
    @NonNull
    public String getId() {
        return this.id;
    }

    public final int hashCode() {
        return IdCredentials.Helpers.hashCode(this);
    }

    public final boolean equals(Object o) {
        return IdCredentials.Helpers.equals(this, o);
    }

    protected static abstract class BaseStandardCredentialsDescriptor
    extends CredentialsDescriptor {
        protected BaseStandardCredentialsDescriptor() {
            this.clazz.asSubclass(BaseStandardCredentials.class);
        }

        protected BaseStandardCredentialsDescriptor(Class<? extends BaseStandardCredentials> clazz) {
            super(clazz);
        }

        @CheckForNull
        private static FormValidation checkForDuplicates(String value, ModelObject context, ModelObject object) {
            CredentialsMatcher withId = CredentialsMatchers.withId(value);
            for (CredentialsStore store : CredentialsProvider.lookupStores(object)) {
                if (!store.hasPermission(CredentialsProvider.VIEW)) continue;
                ModelObject storeContext = store.getContext();
                for (Domain domain : store.getDomains()) {
                    for (Credentials match : CredentialsMatchers.filter(store.getCredentials(domain), withId)) {
                        if (storeContext == context) {
                            return FormValidation.error((String)"This ID is already in use");
                        }
                        CredentialsScope scope = match.getScope();
                        if (scope != null && !scope.isVisible(context)) continue;
                        return FormValidation.warning((String)"The ID \u2018%s\u2019 is already in use in %s", (Object[])new Object[]{value, storeContext instanceof Item ? ((Item)storeContext).getFullDisplayName() : storeContext.getDisplayName()});
                    }
                }
            }
            return null;
        }

        public String getCheckIdUrl(CredentialsStore store) throws UnsupportedEncodingException {
            ModelObject context = store.getContext();
            for (CredentialsSelectHelper.ContextResolver r : ExtensionList.lookup(CredentialsSelectHelper.ContextResolver.class)) {
                String token = r.getToken(context);
                if (token == null) continue;
                return Jenkins.getActiveInstance().getRootUrlFromRequest() + "/" + this.getDescriptorUrl() + "/checkId?provider=" + r.getClass().getName() + "&token=" + URLEncoder.encode(token, "UTF-8");
            }
            return Jenkins.getActiveInstance().getRootUrlFromRequest() + "/" + this.getDescriptorUrl() + "/checkId?provider=null&token=null";
        }

        public final FormValidation doCheckId(@ContextInPath ModelObject context, @QueryParameter String value) {
            Jenkins j;
            User me;
            if (value.isEmpty()) {
                return FormValidation.ok();
            }
            if (!value.matches("[a-zA-Z0-9_.-]+")) {
                return FormValidation.error((String)"Unacceptable characters");
            }
            FormValidation problem = BaseStandardCredentialsDescriptor.checkForDuplicates(value, context, context);
            if (problem != null) {
                return problem;
            }
            if (!(context instanceof User) && (me = User.current()) != null && (problem = BaseStandardCredentialsDescriptor.checkForDuplicates(value, context, (ModelObject)me)) != null) {
                return problem;
            }
            if (!(context instanceof Jenkins) && (j = Jenkins.getInstance()) != null && (problem = BaseStandardCredentialsDescriptor.checkForDuplicates(value, context, (ModelObject)j)) != null) {
                return problem;
            }
            return FormValidation.ok();
        }
    }
}

