/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.cli.declarative.CLIResolver;
import hudson.model.ComputerSet;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.HttpResponses;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Localizable;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class CredentialsSelectHelper
extends Descriptor<CredentialsSelectHelper>
implements Describable<CredentialsSelectHelper> {
    public static final Permission CREATE = CredentialsProvider.CREATE;
    private static final Logger LOGGER = Logger.getLogger(CredentialsSelectHelper.class.getName());

    public CredentialsSelectHelper() {
        super(CredentialsSelectHelper.class);
    }

    public CredentialsSelectHelper getDescriptor() {
        return this;
    }

    @NonNull
    public String getDisplayName() {
        return Messages.CredentialsSelectHelper_DisplayName();
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public ModelObject resolveContext(Object context) {
        if (context instanceof ModelObject) {
            return (ModelObject)context;
        }
        StaplerRequest2 request = Stapler.getCurrentRequest2();
        if (request != null) {
            return (ModelObject)request.findAncestorObject(ModelObject.class);
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public List<StoreItem> getStoreItems(ModelObject context, boolean includeUser) {
        Object request;
        HashSet<String> urls = new HashSet<String>();
        ArrayList<StoreItem> result = new ArrayList<StoreItem>();
        if (context == null && (request = Stapler.getCurrentRequest2()) != null) {
            context = (ModelObject)request.findAncestorObject(ModelObject.class);
        }
        if (context != null) {
            for (CredentialsStore store : CredentialsProvider.lookupStores(context)) {
                StoreItem item = new StoreItem(store);
                String url = item.getUrl();
                if (item.getUrl() == null || urls.contains(url)) continue;
                result.add(item);
                urls.add(url);
            }
        }
        if (includeUser) {
            boolean hasPermission = false;
            ModelObject current = context;
            while (current != null) {
                if (current instanceof AccessControlled) {
                    hasPermission = ((AccessControlled)current).hasPermission(CredentialsProvider.USE_OWN);
                    break;
                }
                if (current instanceof ComputerSet) {
                    current = Jenkins.get();
                    continue;
                }
                current = Jenkins.get();
            }
            if (hasPermission) {
                for (CredentialsStore store : CredentialsProvider.lookupStores((ModelObject)User.current())) {
                    StoreItem item = new StoreItem(store);
                    String url = item.getUrl();
                    if (item.getUrl() == null || urls.contains(url)) continue;
                    result.add(item);
                    urls.add(url);
                }
            }
        }
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasCreatePermission(ModelObject context, boolean includeUser) {
        StaplerRequest2 request;
        User current;
        if (includeUser && (current = User.current()) != null && current.hasPermission(CREATE)) {
            return true;
        }
        if (context == null && (request = Stapler.getCurrentRequest2()) != null) {
            context = (ModelObject)request.findAncestorObject(ModelObject.class);
        }
        for (CredentialsStore store : CredentialsProvider.lookupStores(context)) {
            if (!store.hasPermission(CREATE)) continue;
            return true;
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    public WrappedContextResolver getResolver(String className) {
        return ExtensionList.lookup(ContextResolver.class).stream().filter(r -> r.getClass().getName().equals(className)).findFirst().map(WrappedContextResolver::new).orElse(null);
    }

    @CLIResolver
    public static CredentialsStore resolveForCLI(@Argument(required=true, metaVar="STORE", usage="Store ID") String storeId) throws CmdLineException {
        int index2;
        int index1 = storeId.indexOf("::");
        int n = index2 = index1 == -1 ? -1 : storeId.indexOf("::", index1 + 2);
        if (index1 == -1 || index1 == 0 || index2 == -1 || index2 < index1 + 2 || index2 == storeId.length() - 2) {
            throw new CmdLineException(null, new Localizable(){

                public String formatWithLocale(Locale locale, Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLIMalformedStoreId(objects[0]).toString(locale);
                }

                public String format(Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLIMalformedStoreId(objects[0]).toString();
                }
            }, new String[]{storeId});
        }
        String providerName = storeId.substring(0, index1);
        String resolverName = storeId.substring(index1 + 2, index2);
        String token = storeId.substring(index2 + 2);
        CredentialsProvider provider = CredentialsSelectHelper.getProvidersByName().get(providerName);
        if (provider == null || provider == CredentialsProvider.NONE) {
            throw new CmdLineException(null, new Localizable(){

                public String formatWithLocale(Locale locale, Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoSuchProvider(objects[0]).toString(locale);
                }

                public String format(Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoSuchProvider(objects[0]).toString();
                }
            }, new String[]{storeId});
        }
        ContextResolver resolver = CredentialsSelectHelper.getResolversByName().get(resolverName);
        if (resolver == null || resolver == ContextResolver.NONE) {
            throw new CmdLineException(null, new Localizable(){

                public String formatWithLocale(Locale locale, Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoSuchResolver(objects[0]).toString(locale);
                }

                public String format(Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoSuchResolver(objects[0]).toString();
                }
            }, new String[]{storeId});
        }
        ModelObject context = resolver.getContext(token);
        if (context == null) {
            throw new CmdLineException(null, new Localizable(){

                public String formatWithLocale(Locale locale, Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoSuchContext(objects[0]).toString(locale);
                }

                public String format(Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoSuchContext(objects[0]).toString();
                }
            }, new String[]{storeId});
        }
        CredentialsStore store = provider.getStore(context);
        if (store == null) {
            throw new CmdLineException(null, new Localizable(){

                public String formatWithLocale(Locale locale, Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoStore().toString(locale);
                }

                public String format(Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoStore().toString();
                }
            }, new String[]{storeId});
        }
        return store;
    }

    public static Map<String, ContextResolver> getResolversByName() {
        TreeMap<String, ContextResolver> resolverByName = new TreeMap<String, ContextResolver>();
        for (ContextResolver r2 : ExtensionList.lookup(ContextResolver.class)) {
            resolverByName.put(r2.getClass().getName(), r2);
            String shortName = r2.getClass().getSimpleName();
            resolverByName.put(shortName, resolverByName.containsKey(shortName) ? ContextResolver.NONE : r2);
            if (!StringUtils.isNotBlank((String)(shortName = shortName.toLowerCase(Locale.ENGLISH).replaceAll("(context|resolver|impl)*", "")))) continue;
            resolverByName.put(shortName, resolverByName.containsKey(shortName) ? ContextResolver.NONE : r2);
        }
        resolverByName.values().removeIf(r -> r == ContextResolver.NONE);
        return resolverByName;
    }

    public static Map<String, CredentialsProvider> getProvidersByName() {
        TreeMap<String, CredentialsProvider> providerByName = new TreeMap<String, CredentialsProvider>();
        for (CredentialsProvider r : ExtensionList.lookup(CredentialsProvider.class)) {
            providerByName.put(((Object)((Object)r)).getClass().getName(), r);
            for (Class<?> clazz = ((Object)((Object)r)).getClass(); clazz != null; clazz = clazz.getEnclosingClass()) {
                String shortName = clazz.getSimpleName();
                String simpleName = shortName.toLowerCase(Locale.ENGLISH).replaceAll("(credentials|provider|impl)*", "");
                if (StringUtils.isBlank((String)simpleName)) continue;
                providerByName.put(shortName, providerByName.containsKey(shortName) ? CredentialsProvider.NONE : r);
                providerByName.put(simpleName, providerByName.containsKey(simpleName) ? CredentialsProvider.NONE : r);
            }
        }
        providerByName.values().removeIf(p -> p == CredentialsProvider.NONE);
        return providerByName;
    }

    @Restricted(value={NoExternalUse.class})
    public static final class StoreItem
    implements IconSpec,
    ModelObject {
        private final CredentialsStore store;
        private final String url;

        public StoreItem(CredentialsStore store) {
            this.store = store;
            String provider = ((Object)((Object)store.getProvider())).getClass().getName();
            String resolver = null;
            String token = null;
            ModelObject storeContext = store.getContext();
            for (ContextResolver r : ExtensionList.lookup(ContextResolver.class)) {
                String t = r.getToken(storeContext);
                if (t == null) continue;
                resolver = r.getClass().getName();
                token = t;
                break;
            }
            this.url = token == null ? null : String.format("descriptor/%s/resolver/%s/provider/%s/context/%s", CredentialsSelectHelper.class.getName(), Util.rawEncode((String)resolver), Util.rawEncode((String)provider), Util.rawEncode((String)token));
        }

        public String getIconClassName() {
            return this.store.getProvider().getIconClassName();
        }

        public boolean isEnabled() {
            return this.url != null && this.store.hasPermission(CREATE) && !this.store.getCredentialsDescriptors().isEmpty();
        }

        public String getDisplayName() {
            return this.store.getContextDisplayName();
        }

        public String getDescription() {
            return this.store.getProvider().getDisplayName();
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static abstract class ContextResolver
    implements ExtensionPoint {
        public static final ContextResolver NONE = new ContextResolver(){

            @Override
            public String getToken(ModelObject context) {
                return null;
            }

            @Override
            public ModelObject getContext(String token) {
                return null;
            }

            @Override
            @NonNull
            public String getDisplayName() {
                return "Nothing";
            }
        };

        @CheckForNull
        public abstract String getToken(ModelObject var1);

        @CheckForNull
        public abstract ModelObject getContext(String var1);

        @NonNull
        public abstract String getDisplayName();

        public static String displayName(ContextResolver resolver) {
            try {
                return resolver.getDisplayName();
            }
            catch (AbstractMethodError e) {
                return resolver.getClass().getName();
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class WrappedContextResolver {
        @NonNull
        private final ContextResolver resolver;

        public WrappedContextResolver(@NonNull ContextResolver resolver) {
            this.resolver = resolver;
        }

        @CheckForNull
        public WrappedContextResolverCredentialsProvider getProvider(String className) {
            for (CredentialsProvider p : CredentialsProvider.enabled()) {
                if (!((Object)((Object)p)).getClass().getName().equals(className)) continue;
                return new WrappedContextResolverCredentialsProvider(this.resolver, p);
            }
            return null;
        }
    }

    @Extension
    public static class UserContextResolver
    extends ContextResolver {
        @Override
        public String getToken(ModelObject context) {
            return context instanceof User ? ((User)context).getId() : null;
        }

        @Override
        public ModelObject getContext(String token) {
            return User.getById((String)token, (boolean)false);
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Users";
        }
    }

    @Extension
    public static class ItemContextResolver
    extends ContextResolver {
        @Override
        public String getToken(ModelObject context) {
            return context instanceof Item ? ((Item)context).getFullName() : null;
        }

        @Override
        public ModelObject getContext(String token) {
            return Jenkins.get().getItemByFullName(token);
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Items";
        }
    }

    @Extension(ordinal=1000.0)
    public static class SystemContextResolver
    extends ContextResolver {
        @Override
        public String getToken(ModelObject context) {
            return context instanceof Jenkins ? "jenkins" : null;
        }

        @Override
        public ModelObject getContext(String token) {
            return "jenkins".equals(token) ? Jenkins.get() : null;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Jenkins";
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class WrappedCredentialsStore
    implements IconSpec,
    ModelObject {
        @NonNull
        private final ContextResolver resolver;
        @NonNull
        private final CredentialsProvider provider;
        @NonNull
        private final String token;
        @NonNull
        private final CredentialsStore store;

        public WrappedCredentialsStore(@NonNull ContextResolver resolver, @NonNull CredentialsProvider provider, @NonNull String token, @NonNull CredentialsStore store) {
            this.store = store;
            this.resolver = resolver;
            this.provider = provider;
            this.token = token;
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public JSONObject doAddCredentials(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
            boolean credentialsWereAdded;
            this.store.checkPermission(CredentialsStoreAction.CREATE);
            JSONObject data = req.getSubmittedForm();
            String domainName = data.getString("domain");
            CredentialsStoreAction.DomainWrapper wrapper = this.getWrappers().get(domainName);
            if (!this.store.getDomains().contains(wrapper.getDomain())) {
                HttpResponses.status((int)400).generateResponse(req, rsp, null);
                return new JSONObject().element("message", (Object)"Store does not have selected domain").element("notificationType", (Object)"ERROR");
            }
            this.store.checkPermission(CredentialsStoreAction.CREATE);
            try {
                Credentials credentials = (Credentials)Descriptor.bindJSON((StaplerRequest2)req, Credentials.class, (JSONObject)data.getJSONObject("credentials"));
                credentialsWereAdded = this.store.addCredentials(wrapper.getDomain(), credentials);
            }
            catch (LinkageError e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (rootCause instanceof IOException || rootCause instanceof IllegalArgumentException || rootCause instanceof GeneralSecurityException) {
                    LOGGER.log(Level.WARNING, "Failed to create Credentials", e);
                    return new JSONObject().element("message", (Object)rootCause.getMessage()).element("notificationType", (Object)"ERROR");
                }
                throw e;
            }
            if (credentialsWereAdded) {
                return new JSONObject().element("message", (Object)"Credentials created").element("notificationType", (Object)"SUCCESS");
            }
            return new JSONObject().element("message", (Object)("Credentials with specified ID already exist in " + domainName + " domain")).element("notificationType", (Object)"ERROR");
        }

        public CredentialsStoreAction.DomainWrapper getWrapper() {
            Collection<CredentialsStoreAction.DomainWrapper> values = this.getWrappers().values();
            return values.isEmpty() ? null : values.iterator().next();
        }

        public String getIconClassName() {
            return this.store.getProvider().getIconClassName();
        }

        public String getDisplayName() {
            return this.store.getContextDisplayName();
        }

        public String getDescription() {
            return this.store.getProvider().getDisplayName();
        }

        public String getUrl() {
            return String.format("%sdescriptor/%s/resolver/%s/provider/%s/context/%s", Jenkins.get().getRootUrlFromRequest(), CredentialsSelectHelper.class.getName(), Util.rawEncode((String)this.resolver.getClass().getName()), Util.rawEncode((String)((Object)((Object)this.provider)).getClass().getName()), Util.rawEncode((String)this.token));
        }

        public List<CredentialsDescriptor> getCredentialsDescriptors() {
            return this.store.getCredentialsDescriptors();
        }

        public Map<String, CredentialsStoreAction.DomainWrapper> getWrappers() {
            CredentialsStoreAction action = this.store.getStoreAction();
            return action != null ? action.getDomains() : new CredentialsStoreAction(){

                @Override
                @NonNull
                public CredentialsStore getStore() {
                    return store;
                }
            }.getDomains();
        }

        public CredentialsStore getStore() {
            return this.store;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class WrappedContextResolverCredentialsProvider {
        @NonNull
        private final ContextResolver resolver;
        @NonNull
        private final CredentialsProvider provider;

        public WrappedContextResolverCredentialsProvider(@NonNull ContextResolver resolver, @NonNull CredentialsProvider provider) {
            this.resolver = resolver;
            this.provider = provider;
        }

        public WrappedCredentialsStore getContext(String token) {
            CredentialsStore store;
            ModelObject context = this.resolver.getContext(token);
            if (context != null && (store = this.provider.getStore(context)) != null) {
                return new WrappedCredentialsStore(this.resolver, this.provider, token, store);
            }
            return null;
        }
    }
}

