/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsScope;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.acegisecurity.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CredentialsProvider
implements ExtensionPoint {
    public static DescriptorExtensionList<Credentials, Descriptor<Credentials>> allCredentialsDescriptors() {
        return Hudson.getInstance().getDescriptorList(Credentials.class);
    }

    public Set<CredentialsScope> getScopes(ModelObject object) {
        return null;
    }

    @NonNull
    public abstract <C extends Credentials> List<C> getCredentials(@NonNull Class<C> var1, @Nullable ItemGroup var2, @Nullable Authentication var3);

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication) {
        item.getClass();
        return this.getCredentials(type, item.getParent(), authentication);
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type) {
        return CredentialsProvider.lookupCredentials(type, (Item)null, ACL.SYSTEM);
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentials(type, (ItemGroup)Hudson.getInstance(), authentication);
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item) {
        return item == null ? CredentialsProvider.lookupCredentials(type, (ItemGroup)Hudson.getInstance(), ACL.SYSTEM) : CredentialsProvider.lookupCredentials(type, item, ACL.SYSTEM);
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup) {
        return CredentialsProvider.lookupCredentials(type, itemGroup, ACL.SYSTEM);
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
        ExtensionList providers;
        type.getClass();
        itemGroup = itemGroup == null ? Hudson.getInstance() : itemGroup;
        authentication = authentication == null ? ACL.SYSTEM : authentication;
        try {
            providers = Hudson.getInstance().getExtensionList(CredentialsProvider.class);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        ArrayList<C> result = new ArrayList<C>();
        for (CredentialsProvider provider : providers) {
            try {
                result.addAll(provider.getCredentials(type, itemGroup, authentication));
            }
            catch (NoClassDefFoundError e) {}
        }
        return result;
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication) {
        ExtensionList providers;
        type.getClass();
        if (item == null) {
            return CredentialsProvider.lookupCredentials(type, (ItemGroup)Hudson.getInstance(), authentication);
        }
        authentication = authentication == null ? ACL.SYSTEM : authentication;
        try {
            providers = Hudson.getInstance().getExtensionList(CredentialsProvider.class);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        ArrayList<C> result = new ArrayList<C>();
        for (CredentialsProvider provider : providers) {
            try {
                result.addAll(provider.getCredentials(type, item, authentication));
            }
            catch (NoClassDefFoundError e) {}
        }
        return result;
    }

    @CheckForNull
    public static Set<CredentialsScope> lookupScopes(ModelObject object) {
        ExtensionList providers;
        try {
            providers = Hudson.getInstance().getExtensionList(CredentialsProvider.class);
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
        LinkedHashSet<CredentialsScope> result = null;
        for (CredentialsProvider provider : providers) {
            try {
                Set<CredentialsScope> scopes = provider.getScopes(object);
                if (scopes == null) continue;
                if (result == null) {
                    result = new LinkedHashSet<CredentialsScope>();
                }
                result.addAll(scopes);
            }
            catch (NoClassDefFoundError e) {}
        }
        return result;
    }
}

