/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.impl;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class UsernamePasswordMultiBinding
extends MultiBinding<StandardUsernamePasswordCredentials> {
    private final String usernameVariable;
    private final String passwordVariable;

    @DataBoundConstructor
    public UsernamePasswordMultiBinding(String usernameVariable, String passwordVariable, String credentialsId) {
        super(credentialsId);
        this.usernameVariable = usernameVariable;
        this.passwordVariable = passwordVariable;
    }

    public String getUsernameVariable() {
        return this.usernameVariable;
    }

    public String getPasswordVariable() {
        return this.passwordVariable;
    }

    @Override
    protected Class<StandardUsernamePasswordCredentials> type() {
        return StandardUsernamePasswordCredentials.class;
    }

    @Override
    public MultiBinding.MultiEnvironment bind(@Nonnull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)this.getCredentials(build);
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put(this.usernameVariable, credentials.getUsername());
        m.put(this.passwordVariable, credentials.getPassword().getPlainText());
        return new MultiBinding.MultiEnvironment(m);
    }

    @Override
    public Set<String> variables() {
        return new HashSet<String>(Arrays.asList(this.usernameVariable, this.passwordVariable));
    }

    @Symbol(value={"usernamePassword"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<StandardUsernamePasswordCredentials> {
        @Override
        protected Class<StandardUsernamePasswordCredentials> type() {
            return StandardUsernamePasswordCredentials.class;
        }

        public String getDisplayName() {
            return Messages.UsernamePasswordMultiBinding_username_and_password();
        }

        @Override
        public boolean requiresWorkspace() {
            return false;
        }
    }
}

