/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.impl;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.AbstractOnDiskBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.Messages;
import org.jenkinsci.plugins.credentialsbinding.impl.UnbindableDir;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.kohsuke.stapler.DataBoundConstructor;

public class FileBinding
extends AbstractOnDiskBinding<FileCredentials> {
    @DataBoundConstructor
    public FileBinding(String variable, String credentialsId) {
        super(variable, credentialsId);
    }

    @Override
    protected Class<FileCredentials> type() {
        return FileCredentials.class;
    }

    @Override
    protected final FilePath write(FileCredentials credentials, FilePath dir) throws IOException, InterruptedException {
        FilePath secret = dir.child(credentials.getFileName());
        secret.copyFrom(credentials.getContent());
        secret.chmod(256);
        return secret;
    }

    @Symbol(value={"file"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<FileCredentials> {
        @Override
        protected Class<FileCredentials> type() {
            return FileCredentials.class;
        }

        public String getDisplayName() {
            return Messages.FileBinding_secret_file();
        }
    }

    @Deprecated
    private static class UnbinderImpl
    implements MultiBinding.Unbinder {
        private static final long serialVersionUID = 1L;
        private final String dirName;

        private UnbinderImpl(String dirName) {
            this.dirName = dirName;
        }

        protected Object readResolve() {
            return new UnbindableDir.UnbinderImpl(this.dirName);
        }

        @Override
        public void unbind(@Nonnull Run<?, ?> build, FilePath workspace, Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        }
    }
}

