/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.impl.CredentialNotFoundException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class MultiBinding<C extends StandardCredentials>
extends AbstractDescribableImpl<MultiBinding<C>>
implements ExtensionPoint {
    private final String credentialsId;
    private static final Comparator<String> stringLengthComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o2.length() - o1.length();
        }
    };

    protected MultiBinding(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    protected abstract Class<C> type();

    public final String getCredentialsId() {
        return this.credentialsId;
    }

    public abstract MultiEnvironment bind(@Nonnull Run<?, ?> var1, @Nullable FilePath var2, @Nullable Launcher var3, @Nonnull TaskListener var4) throws IOException, InterruptedException;

    public abstract Set<String> variables();

    @Nonnull
    protected final C getCredentials(@Nonnull Run<?, ?> build) throws IOException {
        IdCredentials cred = CredentialsProvider.findCredentialById((String)this.credentialsId, IdCredentials.class, build, (DomainRequirement[])new DomainRequirement[0]);
        if (cred == null) {
            throw new CredentialNotFoundException(this.credentialsId);
        }
        if (this.type().isInstance(cred)) {
            CredentialsProvider.track(build, (Credentials)cred);
            return (C)((StandardCredentials)this.type().cast(cred));
        }
        Descriptor expected = Jenkins.getActiveInstance().getDescriptor(this.type());
        throw new CredentialNotFoundException("Credentials '" + this.credentialsId + "' is of type '" + cred.getDescriptor().getDisplayName() + "' where '" + (expected != null ? expected.getDisplayName() : this.type().getName()) + "' was expected");
    }

    public BindingDescriptor<C> getDescriptor() {
        return (BindingDescriptor)super.getDescriptor();
    }

    @Restricted(value={NoExternalUse.class})
    public static String getPatternStringForSecrets(Collection<String> secrets) {
        StringBuilder b = new StringBuilder();
        ArrayList<String> sortedByLength = new ArrayList<String>(secrets);
        Collections.sort(sortedByLength, stringLengthComparator);
        for (String secret : sortedByLength) {
            if (secret.isEmpty()) continue;
            if (b.length() > 0) {
                b.append('|');
            }
            b.append(Pattern.quote(secret));
        }
        return b.toString();
    }

    protected static final class NullUnbinder
    implements Unbinder {
        private static final long serialVersionUID = 1L;

        protected NullUnbinder() {
        }

        @Override
        public void unbind(@Nonnull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        }
    }

    public static interface Unbinder
    extends Serializable {
        public void unbind(@Nonnull Run<?, ?> var1, @Nullable FilePath var2, @Nullable Launcher var3, @Nonnull TaskListener var4) throws IOException, InterruptedException;
    }

    public static final class MultiEnvironment
    implements Serializable {
        private final Map<String, String> values;
        private final Unbinder unbinder;

        public MultiEnvironment(Map<String, String> values) {
            this(values, new NullUnbinder());
        }

        public MultiEnvironment(Map<String, String> values, Unbinder unbinder) {
            this.values = new HashMap<String, String>(values);
            this.unbinder = unbinder;
        }

        public Map<String, String> getValues() {
            return Collections.unmodifiableMap(this.values);
        }

        public Unbinder getUnbinder() {
            return this.unbinder;
        }
    }
}

