/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.helpers;

import hudson.model.BuildListener;
import hudson.plugins.helpers.BuildProxy;
import hudson.plugins.helpers.Ghostwriter;
import java.io.IOException;
import jenkins.security.MasterToSlaveCallable;

class BuildProxyCallableHelper
extends MasterToSlaveCallable<BuildProxy, Exception> {
    private final BuildProxy buildProxy;
    private final Ghostwriter ghostwriter;
    private final BuildListener listener;

    BuildProxyCallableHelper(BuildProxy buildProxy, Ghostwriter ghostwriter, BuildListener listener) {
        this.buildProxy = buildProxy;
        this.ghostwriter = ghostwriter;
        this.listener = listener;
    }

    public BuildProxy call() throws Exception {
        if (this.ghostwriter instanceof Ghostwriter.SlaveGhostwriter) {
            Ghostwriter.SlaveGhostwriter slaveBuildStep = (Ghostwriter.SlaveGhostwriter)this.ghostwriter;
            try {
                this.buildProxy.setContinueBuild(slaveBuildStep.performFromSlave(this.buildProxy, this.listener));
                return this.buildProxy;
            }
            catch (IOException e) {
                throw new Exception(e);
            }
            catch (InterruptedException e) {
                throw new Exception(e);
            }
        }
        return this.buildProxy;
    }
}

