/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.helpers;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.HealthReportingAction;
import hudson.model.Run;
import hudson.plugins.cppncss.parser.StatisticSummary;
import hudson.plugins.cppncss.parser.StringStatisticSummary;
import java.io.Serializable;
import jenkins.model.RunAction2;

public abstract class AbstractBuildAction<BUILD extends AbstractBuild<?, ?>>
implements HealthReportingAction,
Serializable,
RunAction2 {
    private static final long serialVersionUID = 31415926L;
    private transient BUILD build = null;

    protected AbstractBuildAction() {
    }

    public synchronized BUILD getBuild() {
        return this.build;
    }

    public synchronized void setBuild(BUILD build) {
        if (this.build == null && this.build != build) {
            this.build = build;
        }
    }

    private BUILD runToBuild(Run<?, ?> run) throws IllegalStateException {
        AbstractBuild b;
        try {
            b = (AbstractBuild)run;
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException("Action is attached to a wrong job type for run " + run.getFullDisplayName(), ex);
        }
        return (BUILD)b;
    }

    public final void onAttached(Run<?, ?> r) {
        this.setBuild(this.runToBuild(r));
    }

    public final void onLoad(Run<?, ?> r) {
        this.setBuild(this.runToBuild(r));
    }

    public boolean isFloatingBoxActive() {
        return true;
    }

    public boolean isGraphActive() {
        return false;
    }

    public String getGraphName() {
        return this.getDisplayName();
    }

    @Deprecated
    public String getSummary() {
        if (Util.isOverridden(AbstractBuildAction.class, this.getClass(), (String)"getStatisticSummary", (Class[])new Class[0])) {
            return this.getStatisticSummary().getHtmlSummary();
        }
        return "";
    }

    public StatisticSummary getStatisticSummary() {
        return new StringStatisticSummary(this.getSummary());
    }
}

