/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss.parser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.AbstractBuild;
import hudson.plugins.cppncss.parser.Statistic;
import hudson.plugins.cppncss.parser.StatisticsTotalResult;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckForNull;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Not used in XStream")
public class StatisticsResult
implements Serializable {
    private Collection<Statistic> functionResults = Collections.emptySet();
    private Collection<Statistic> fileResults = Collections.emptySet();
    @Deprecated
    @CheckForNull
    private transient AbstractBuild<?, ?> owner;

    public void setFunctionResults(Collection<Statistic> functionResults) {
        this.functionResults = functionResults;
    }

    public Collection<Statistic> getFunctionResults() {
        return this.functionResults;
    }

    public void setFileResults(Collection<Statistic> fileResults) {
        this.fileResults = fileResults;
    }

    public Collection<Statistic> getFileResults() {
        return this.fileResults;
    }

    public static StatisticsResult merge(StatisticsResult results, StatisticsResult result) {
        StatisticsResult mergeResult = new StatisticsResult();
        mergeResult.setFileResults(Statistic.merge(results.getFileResults(), result.getFileResults()));
        mergeResult.setFunctionResults(Statistic.merge(results.getFunctionResults(), result.getFunctionResults()));
        return mergeResult;
    }

    public static StatisticsTotalResult total(StatisticsResult results) {
        StatisticsTotalResult totalResult = new StatisticsTotalResult();
        totalResult.setFunctionTotal(Statistic.total(results.getFunctionResults()));
        totalResult.setFileTotal(Statistic.total(results.getFileResults()));
        return totalResult;
    }

    public void clear() {
        this.functionResults.clear();
        this.fileResults.clear();
    }

    @Deprecated
    @CheckForNull
    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public void setOwner(AbstractBuild<?, ?> owner) {
        this.owner = owner;
        for (Statistic result : this.functionResults) {
            result.setOwner(owner);
        }
        for (Statistic result : this.fileResults) {
            result.setOwner(owner);
        }
    }

    public void set(StatisticsResult that) {
        this.fileResults = that.fileResults;
        this.functionResults = that.functionResults;
    }
}

