/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss.parser;

import hudson.plugins.cppncss.parser.Statistic;
import hudson.plugins.cppncss.parser.StatisticSummary;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class FormattedStatisticSummary
extends StatisticSummary {
    private final long wasFunctions;
    private final long wasNcss;
    private final long wasCcn;
    private final long functions;
    private final long ncss;
    private final long ccn;

    public FormattedStatisticSummary(long wasCcn, long wasFunctions, long wasNcss, long ccn, long functions, long ncss) {
        this.wasFunctions = wasFunctions;
        this.wasNcss = wasNcss;
        this.wasCcn = wasCcn;
        this.functions = functions;
        this.ncss = ncss;
        this.ccn = ccn;
    }

    public FormattedStatisticSummary(long ccn, long functions, long ncss) {
        this(0L, 0L, 0L, ccn, functions, ncss);
    }

    public FormattedStatisticSummary(@Nonnull Statistic was, @Nonnull Statistic now) {
        this(was.getCcn(), was.getFunctions(), was.getNcss(), now.getCcn(), now.getFunctions(), now.getNcss());
    }

    public long getCcn() {
        return this.ccn;
    }

    public long getFunctions() {
        return this.functions;
    }

    public long getNcss() {
        return this.ncss;
    }

    private static String diff(long a, long b, String name) {
        if (a == b) {
            return "";
        }
        if (a < b) {
            return "<li>" + name + " (+" + (b - a) + ")</li>";
        }
        return "<li>" + name + " (-" + (a - b) + ")</li>";
    }

    @Override
    public String getHtmlSummary() {
        return "<ul>" + FormattedStatisticSummary.diff(this.wasCcn, this.ccn, "ccn") + FormattedStatisticSummary.diff(this.wasFunctions, this.functions, "functions") + FormattedStatisticSummary.diff(this.wasCcn, this.ncss, "ncss") + "</ul>";
    }

    public String toString() {
        return String.format("cnn: %s, functions: %s, ncss: %s. Was: %s/%s/%s", this.ccn, this.functions, this.ncss, this.wasCcn, this.wasFunctions, this.wasNcss);
    }
}

