/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.cppncss.CppNCSSGhostwriter;
import hudson.plugins.cppncss.CppNCSSHealthMetrics;
import hudson.plugins.cppncss.CppNCSSHealthTarget;
import hudson.plugins.cppncss.CppNCSSProjectIndividualReport;
import hudson.plugins.helpers.AbstractPublisherImpl;
import hudson.plugins.helpers.Ghostwriter;
import hudson.plugins.helpers.health.HealthMetric;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.DataBoundConstructor;

public class CppNCSSPublisher
extends AbstractPublisherImpl {
    private String reportFilenamePattern;
    private Integer functionCcnViolationThreshold = 10;
    private Integer functionNcssViolationThreshold = 100;
    private CppNCSSHealthTarget[] targets;

    @DataBoundConstructor
    public CppNCSSPublisher(String reportFilenamePattern, Integer functionCcnViolationThreshold, Integer functionNcssViolationThreshold, CppNCSSHealthTarget[] targets) {
        reportFilenamePattern.getClass();
        this.reportFilenamePattern = reportFilenamePattern;
        this.functionCcnViolationThreshold = functionCcnViolationThreshold;
        this.functionNcssViolationThreshold = functionNcssViolationThreshold;
        this.targets = targets == null ? new CppNCSSHealthTarget[]{} : targets;
    }

    public String getReportFilenamePattern() {
        return this.reportFilenamePattern;
    }

    public Integer getFunctionCcnViolationThreshold() {
        return this.functionCcnViolationThreshold;
    }

    public Integer getFunctionNcssViolationThreshold() {
        return this.functionNcssViolationThreshold;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Legacy code, suppressed due to the performance reasons")
    public CppNCSSHealthTarget[] getTargets() {
        return this.targets;
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CppNCSSProjectIndividualReport(project, this.functionCcnViolationThreshold, this.functionNcssViolationThreshold);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Override
    protected Ghostwriter newGhostwriter() {
        return new CppNCSSGhostwriter(this.reportFilenamePattern, this.functionCcnViolationThreshold, this.functionNcssViolationThreshold, this.targets);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Publish Cpp NCSS Report";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public HealthMetric[] getMetrics() {
            return CppNCSSHealthMetrics.values();
        }

        static {
            ConvertUtils.register((Converter)CppNCSSHealthMetrics.CONVERTER, CppNCSSHealthMetrics.class);
        }
    }
}

