/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss;

import hudson.model.AbstractBuild;
import hudson.plugins.cppncss.AbstractBuildReport;
import hudson.plugins.cppncss.CppNCSSBuildIndividualReport;
import hudson.plugins.cppncss.parser.Statistic;
import hudson.plugins.helpers.health.HealthMetric;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.beanutils.Converter;

public enum CppNCSSHealthMetrics implements HealthMetric<CppNCSSBuildIndividualReport>
{
    TOT_CCN_RATIO{

        @Override
        public String getName() {
            return "Total CCN";
        }

        @Override
        public float measure(CppNCSSBuildIndividualReport report) {
            float ccn = report.getTotals().getFileTotal().getCcn();
            return ccn;
        }

        @Override
        public float measureNew(CppNCSSBuildIndividualReport observable) {
            return 1.measureNew(this, observable);
        }

        @Override
        public float getBest() {
            return 0.0f;
        }

        @Override
        public float getWorst() {
            return 1000.0f;
        }
    }
    ,
    AVG_FILE_CCN_RATIO{

        @Override
        public String getName() {
            return "Average File CCN";
        }

        @Override
        public float measure(CppNCSSBuildIndividualReport report) {
            float ccn = report.getTotals().getFileTotal().getCcn();
            float number_of_files = report.getResults().getFileResults().size();
            return ccn / number_of_files;
        }

        @Override
        public float measureNew(CppNCSSBuildIndividualReport observable) {
            return 2.measureNew(this, observable);
        }

        @Override
        public float getBest() {
            return 0.0f;
        }

        @Override
        public float getWorst() {
            return 1000.0f;
        }
    }
    ,
    NUMBER_OF_CCN_VIOLATED_FUNCTION{

        @Override
        public String getName() {
            return "Number of CCN violated functions";
        }

        @Override
        public float measure(CppNCSSBuildIndividualReport report) {
            int totalViolations = 0;
            Collection<Statistic> functionResults = report.getResults().getFunctionResults();
            for (Statistic statistic : functionResults) {
                if (statistic.getCcn() < (long)report.getFunctionCcnViolationThreshold().intValue()) continue;
                ++totalViolations;
            }
            return totalViolations;
        }

        @Override
        public float measureNew(CppNCSSBuildIndividualReport observable) {
            return 3.measureNew(this, observable);
        }

        @Override
        public float getBest() {
            return 0.0f;
        }

        @Override
        public float getWorst() {
            return 100.0f;
        }
    }
    ,
    UMBER_OF_NCSS_VIOLATED_FUNCTION{

        @Override
        public String getName() {
            return "Number of NCSS violated functions";
        }

        @Override
        public float measure(CppNCSSBuildIndividualReport report) {
            int totalViolations = 0;
            Collection<Statistic> functionResults = report.getResults().getFunctionResults();
            for (Statistic statistic : functionResults) {
                if (statistic.getNcss() < (long)report.getFunctionNcssViolationThreshold().intValue()) continue;
                ++totalViolations;
            }
            return totalViolations;
        }

        @Override
        public float measureNew(CppNCSSBuildIndividualReport observable) {
            return 4.measureNew(this, observable);
        }

        @Override
        public float getBest() {
            return 0.0f;
        }

        @Override
        public float getWorst() {
            return 100.0f;
        }
    };

    static Converter CONVERTER;

    static float measureNew(CppNCSSHealthMetrics metrics, CppNCSSBuildIndividualReport observable) {
        float newValue = metrics.measure(observable);
        Object currentBuild = observable.getBuild();
        CppNCSSBuildIndividualReport previousReport = CppNCSSHealthMetrics.getPreviousCppNCSSReport(currentBuild);
        if (previousReport != null) {
            float oldValue = metrics.measure(previousReport);
            return newValue - oldValue;
        }
        return newValue;
    }

    @CheckForNull
    private static CppNCSSBuildIndividualReport getPreviousCppNCSSReport(@Nonnull AbstractBuild<?, ?> build) {
        for (AbstractBuild previousBuild = build.getPreviousBuild(); previousBuild != null; previousBuild = previousBuild.getPreviousBuild()) {
            AbstractBuildReport report = (AbstractBuildReport)previousBuild.getAction(AbstractBuildReport.class);
            if (!(report instanceof CppNCSSBuildIndividualReport)) continue;
            return (CppNCSSBuildIndividualReport)report;
        }
        return null;
    }

    static {
        CONVERTER = new Converter(){

            public Object convert(Class aClass, Object o) {
                return CppNCSSHealthMetrics.valueOf(o.toString());
            }
        };
    }
}

