/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.ws;

import com.coverity.ws.v9.ConfigurationService;
import com.coverity.ws.v9.ConfigurationServiceService;
import com.coverity.ws.v9.DefectService;
import com.coverity.ws.v9.DefectServiceService;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.ws.ClientAuthenticationHandlerWSS;
import jenkins.plugins.coverity.ws.ViewsService;

public class WebServiceFactory {
    private static final Logger logger = Logger.getLogger(WebServiceFactory.class.getName());
    private static WebServiceFactory instance = null;
    public static final String COVERITY_V9_NAMESPACE = "http://ws.coverity.com/v9";
    public static final String DEFECT_SERVICE_V9_WSDL = "/ws/v9/defectservice?wsdl";
    public static final String CONFIGURATION_SERVICE_V9_WSDL = "/ws/v9/configurationservice?wsdl";
    private Map<CIMInstance, DefectService> defectServiceMap = new HashMap<CIMInstance, DefectService>();
    private Map<CIMInstance, ConfigurationService> configurationServiceMap = new HashMap<CIMInstance, ConfigurationService>();

    protected WebServiceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServiceFactory getInstance() {
        Class<WebServiceFactory> clazz = WebServiceFactory.class;
        synchronized (WebServiceFactory.class) {
            if (instance == null) {
                instance = new WebServiceFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefectService getDefectService(CIMInstance cimInstance) throws IOException {
        DefectService defectService;
        WebServiceFactory webServiceFactory = this;
        synchronized (webServiceFactory) {
            if (!this.defectServiceMap.containsKey(cimInstance)) {
                defectService = this.createDefectService(cimInstance);
                this.defectServiceMap.put(cimInstance, defectService);
            } else {
                defectService = this.defectServiceMap.get(cimInstance);
            }
        }
        return defectService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefectService createDefectService(CIMInstance cimInstance) throws MalformedURLException {
        DefectServiceService defectServiceService = new DefectServiceService(new URL(this.getURL(cimInstance), DEFECT_SERVICE_V9_WSDL), new QName(COVERITY_V9_NAMESPACE, "DefectServiceService"));
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            DefectService defectService = defectServiceService.getDefectServicePort();
            this.attachAuthenticationHandler((BindingProvider)defectService, cimInstance);
            DefectService defectService2 = defectService;
            return defectService2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationService getConfigurationService(CIMInstance cimInstance) throws IOException {
        ConfigurationService configurationService;
        WebServiceFactory webServiceFactory = this;
        synchronized (webServiceFactory) {
            if (!this.configurationServiceMap.containsKey(cimInstance)) {
                configurationService = this.createConfigurationService(cimInstance);
                this.configurationServiceMap.put(cimInstance, configurationService);
            } else {
                configurationService = this.configurationServiceMap.get(cimInstance);
            }
        }
        return configurationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigurationService createConfigurationService(CIMInstance cimInstance) throws MalformedURLException {
        ConfigurationServiceService configurationServiceService = new ConfigurationServiceService(new URL(this.getURL(cimInstance), CONFIGURATION_SERVICE_V9_WSDL), new QName(COVERITY_V9_NAMESPACE, "ConfigurationServiceService"));
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            ConfigurationService configurationService = configurationServiceService.getConfigurationServicePort();
            this.attachAuthenticationHandler((BindingProvider)configurationService, cimInstance);
            ConfigurationService configurationService2 = configurationService;
            return configurationService2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public ViewsService getViewService(CIMInstance instance) throws MalformedURLException, NoSuchAlgorithmException {
        URL baseUrl = this.getURL(instance);
        DefaultClientConfig config = new DefaultClientConfig();
        if (instance.isUseSSL()) {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            HTTPSProperties httpsProperties = new HTTPSProperties(HttpsURLConnection.getDefaultHostnameVerifier(), sslContext);
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", httpsProperties);
        }
        Client restClient = Client.create();
        restClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(instance.getCoverityUser(), instance.getCoverityPassword()));
        return new ViewsService(baseUrl, restClient);
    }

    protected URL getURL(CIMInstance cimInstance) throws MalformedURLException {
        return new URL(cimInstance.isUseSSL() ? "https" : "http", cimInstance.getHost(), cimInstance.getPort(), "/");
    }

    public CheckWsResponse getCheckWsResponse(CIMInstance cimInstance) {
        try {
            return this.getCheckWsResponse(new URL(this.getURL(cimInstance), CONFIGURATION_SERVICE_V9_WSDL));
        }
        catch (MalformedURLException e) {
            return new CheckWsResponse(-1, e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private CheckWsResponse getCheckWsResponse(URL url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.connect();
            conn.getInputStream();
            return new CheckWsResponse(conn.getResponseCode(), conn.getResponseMessage());
        }
        catch (FileNotFoundException e) {
            return new CheckWsResponse(404, "URL '" + url + "' not found");
        }
        catch (IOException e) {
            return new CheckWsResponse(-1, e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private void attachAuthenticationHandler(BindingProvider service, CIMInstance cimInstance) {
        service.getBinding().setHandlerChain(Arrays.asList(new ClientAuthenticationHandlerWSS(cimInstance.getCoverityUser(), cimInstance.getCoverityPassword())));
    }

    public static class CheckWsResponse {
        private final int responseCode;
        private final String responseMessage;

        public CheckWsResponse(int responseCode, String responseMessage) {
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String toString() {
            return "Check Coverity Web Service Response: { Code=" + this.responseCode + ", Message=\"" + this.responseMessage + "\" " + '}';
        }
    }
}

