/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.ws;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import jenkins.plugins.coverity.ws.ViewContents;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ViewsService {
    private static final Logger logger = Logger.getLogger(ViewsService.class.getName());
    private final URL coverityConnectUrl;
    private final Client restClient;

    public ViewsService(URL coverityConnectUrl, Client restClient) {
        this.coverityConnectUrl = coverityConnectUrl;
        this.restClient = restClient;
    }

    public Map<Long, String> getViews() {
        JSONObject json;
        HashMap<Long, String> views = new HashMap<Long, String>();
        try {
            UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.coverityConnectUrl.toURI()).path("api/views/v1");
            WebResource resource = this.restClient.resource(uriBuilder.build(new Object[0]));
            String response = (String)resource.get(String.class);
            JSONParser parser = new JSONParser();
            json = (JSONObject)parser.parse(response);
        }
        catch (URISyntaxException | ParseException e) {
            logger.throwing(ViewsService.class.getName(), "getViews", e);
            return views;
        }
        JSONArray jsonViews = (JSONArray)json.get((Object)"views");
        for (Object view : jsonViews) {
            JSONObject jsonView = (JSONObject)view;
            String type = (String)jsonView.get((Object)"type");
            if (type == null || !type.equals("issues")) continue;
            Long viewId = (Long)jsonView.get((Object)"id");
            String viewName = (String)jsonView.get((Object)"name");
            if (viewId == null || viewName == null) continue;
            views.put(viewId, viewName);
        }
        return views;
    }

    public ViewContents getViewContents(String projectId, String connectView, int pageSize, int offset) {
        try {
            UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.coverityConnectUrl.toURI()).path("api/viewContents/issues/v1/").path(connectView).queryParam("projectId", new Object[]{projectId}).queryParam("rowCount", new Object[]{pageSize}).queryParam("offset", new Object[]{offset});
            URI viewContentsUri = uriBuilder.build(new Object[0]);
            logger.info("Retrieving View contents from " + viewContentsUri);
            WebResource resource = this.restClient.resource(viewContentsUri);
            ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
            if (response.getStatus() != 200) {
                throw new RuntimeException("GET " + viewContentsUri + " returned a response status of " + response.getStatus() + ": " + (String)response.getEntity(String.class));
            }
            String output = (String)response.getEntity(String.class);
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse(output);
            return new ViewContents((JSONObject)json.get((Object)"viewContentsV1"));
        }
        catch (URISyntaxException | ParseException e) {
            logger.throwing(ViewsService.class.getName(), "getViews", e);
            return new ViewContents(new JSONObject());
        }
    }
}

