/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.ws;

import hudson.model.Action;
import hudson.model.Run;
import java.io.PrintStream;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CoverityBuildAction;
import jenkins.plugins.coverity.CoverityDefect;
import jenkins.plugins.coverity.CoverityViewResultsPublisher;
import org.apache.commons.lang.StringUtils;

public class ViewIssuesReader {
    private Run<?, ?> run;
    private PrintStream outputLogger;
    private CoverityViewResultsPublisher publisher;

    public ViewIssuesReader(@Nonnull Run<?, ?> run, PrintStream outputLogger, CoverityViewResultsPublisher publisher) {
        this.run = run;
        this.outputLogger = outputLogger;
        this.publisher = publisher;
    }

    public void getIssuesFromConnectView() throws Exception {
        CIMInstance instance = this.publisher.getInstance();
        if (instance != null) {
            List<CoverityDefect> issuesFromView = instance.getIssuesVorView(this.publisher.getProjectId(), this.publisher.getConnectView(), this.outputLogger);
            CoverityBuildAction action = new CoverityBuildAction(this.run, this.publisher.getProjectId(), this.publisher.getConnectView(), this.publisher.getConnectInstance(), issuesFromView);
            this.run.addAction((Action)action);
            String rootUrl = Jenkins.getInstance().getRootUrl();
            if (StringUtils.isNotEmpty((String)rootUrl)) {
                this.outputLogger.println("Coverity details: " + rootUrl + this.run.getUrl() + action.getUrlName());
            }
        }
    }
}

