/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.ws;

import com.coverity.ws.v9.CovRemoteServiceException_Exception;
import com.coverity.ws.v9.DefectService;
import com.coverity.ws.v9.MergedDefectDataObj;
import com.coverity.ws.v9.MergedDefectFilterSpecDataObj;
import com.coverity.ws.v9.MergedDefectsPageDataObj;
import com.coverity.ws.v9.PageSpecDataObj;
import com.coverity.ws.v9.SnapshotScopeSpecDataObj;
import com.coverity.ws.v9.StreamIdDataObj;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CIMStream;
import jenkins.plugins.coverity.CoverityBuildAction;
import jenkins.plugins.coverity.CoverityDefect;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.DefectFilters;
import org.apache.commons.lang.StringUtils;

public class DefectReader {
    private AbstractBuild<?, ?> build;
    private BuildListener listener;
    private CoverityPublisher publisher;

    public DefectReader(AbstractBuild<?, ?> build, BuildListener listener, CoverityPublisher publisher) {
        this.build = build;
        this.listener = listener;
        this.publisher = publisher;
    }

    public void getLatestDefectsForBuild() {
        if (this.publisher.getSkipFetchingDefects()) {
            return;
        }
        CIMStream cimStream = this.publisher.getCimStream();
        CIMInstance cimInstance = this.publisher.getDescriptor().getInstance(this.publisher);
        if (StringUtils.isEmpty((String)cimStream.getStream())) {
            this.listener.getLogger().println("[Coverity] Stream has not been configured. Skipping fetching defects.");
            return;
        }
        this.listener.getLogger().println(MessageFormat.format("[Coverity] Fetching defects for stream \"{0}\"", cimStream.getStream()));
        List<MergedDefectDataObj> defects = null;
        try {
            defects = this.getDefectsForSnapshot(cimInstance, cimStream, this.listener.getLogger());
            ArrayList<CoverityDefect> matchingDefects = new ArrayList<CoverityDefect>();
            for (MergedDefectDataObj defect : defects) {
                matchingDefects.add(new CoverityDefect(defect.getCid(), defect.getCheckerName(), defect.getFunctionDisplayName(), defect.getFilePathname()));
            }
            if (!matchingDefects.isEmpty()) {
                this.listener.getLogger().println(MessageFormat.format("[Coverity] Found {0} defects matching all filters", matchingDefects.size()));
                if (this.publisher.isFailBuild() && this.build.getResult().isBetterThan(Result.FAILURE)) {
                    this.build.setResult(Result.FAILURE);
                }
                if (this.publisher.isUnstable()) {
                    this.publisher.setUnstableBuild(true);
                }
            } else {
                this.listener.getLogger().println("[Coverity] No defects matched all filters.");
            }
            CoverityBuildAction action = new CoverityBuildAction((Run<?, ?>)this.build, cimStream.getProject(), cimStream.getStream(), cimStream.getInstance(), (List<CoverityDefect>)matchingDefects);
            this.build.addAction((Action)action);
            String rootUrl = Jenkins.getInstance().getRootUrl();
            if (StringUtils.isNotEmpty((String)rootUrl)) {
                this.listener.getLogger().println("Coverity details: " + rootUrl + this.build.getUrl() + action.getUrlName());
            }
        }
        catch (IOException e) {
            e.printStackTrace(this.listener.error("[Coverity] An error occurred while fetching defects"));
            this.build.setResult(Result.FAILURE);
        }
        catch (CovRemoteServiceException_Exception e) {
            e.printStackTrace(this.listener.error("[Coverity] An error occurred while fetching defects"));
            this.build.setResult(Result.FAILURE);
        }
    }

    private List<MergedDefectDataObj> getDefectsForSnapshot(CIMInstance cim, CIMStream cimStream, PrintStream logger) throws IOException, CovRemoteServiceException_Exception {
        ArrayList<MergedDefectDataObj> mergeList = new ArrayList<MergedDefectDataObj>();
        DefectService ds = cim.getDefectService();
        StreamIdDataObj streamId = new StreamIdDataObj();
        streamId.setName(cimStream.getStream());
        ArrayList<StreamIdDataObj> streamIds = new ArrayList<StreamIdDataObj>();
        streamIds.add(streamId);
        DefectFilters defectFilters = cimStream.getDefectFilters();
        MergedDefectFilterSpecDataObj filter = defectFilters != null ? defectFilters.ToFilterSpecDataObj() : new MergedDefectFilterSpecDataObj();
        PageSpecDataObj pageSpec = new PageSpecDataObj();
        SnapshotScopeSpecDataObj snapshotScope = new SnapshotScopeSpecDataObj();
        snapshotScope.setShowSelector("last()");
        int pageSize = 1000;
        int defectSize = 3000;
        for (int pageStart = 0; pageStart < defectSize; pageStart += pageSize) {
            if (pageStart >= pageSize) {
                logger.println(MessageFormat.format("[Coverity] Fetching defects for stream \"{0}\" (fetched {1} of {2})", cimStream.getStream(), pageStart, defectSize));
            }
            pageSpec.setPageSize(pageSize);
            pageSpec.setStartIndex(pageStart);
            pageSpec.setSortAscending(true);
            MergedDefectsPageDataObj mergedDefectsForStreams = ds.getMergedDefectsForStreams(streamIds, filter, pageSpec, snapshotScope);
            defectSize = mergedDefectsForStreams.getTotalNumberOfRecords();
            mergeList.addAll(mergedDefectsForStreams.getMergedDefects());
        }
        return mergeList;
    }
}

