/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.ws;

import com.coverity.ws.v9.ConfigurationService;
import com.coverity.ws.v9.CovRemoteServiceException_Exception;
import com.coverity.ws.v9.ProjectDataObj;
import com.coverity.ws.v9.ProjectFilterSpecDataObj;
import com.coverity.ws.v9.StreamDataObj;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.plugins.coverity.CIMInstance;

public final class CimCache {
    private static CimCache instance = null;
    private Map<CIMInstance, CachedData> cache = new HashMap<CIMInstance, CachedData>();

    private CimCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CimCache getInstance() {
        Class<CimCache> clazz = CimCache.class;
        synchronized (CimCache.class) {
            if (instance == null) {
                instance = new CimCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void cacheCimInstance(CIMInstance cimInstance) {
        this.cache.put(cimInstance, new CachedData(cimInstance));
    }

    public List<String> getProjects(CIMInstance cimInstance) {
        if (this.cache.containsKey(cimInstance)) {
            CachedData cachedData = this.cache.get(cimInstance);
            return cachedData.getAvailableProjects();
        }
        CachedData cachedData = new CachedData(cimInstance);
        this.cache.put(cimInstance, cachedData);
        return cachedData.getAvailableProjects();
    }

    public List<String> getStreams(CIMInstance cimInstance, String project) {
        if (this.cache.containsKey(cimInstance)) {
            CachedData cachedData = this.cache.get(cimInstance);
            return cachedData.getStreamsForProject(project);
        }
        CachedData cachedData = new CachedData(cimInstance);
        this.cache.put(cimInstance, cachedData);
        return cachedData.getStreamsForProject(project);
    }

    private static class CachedData {
        private Map<String, List<String>> projectStreams = new HashMap<String, List<String>>();

        public CachedData(CIMInstance cimInstance) {
            try {
                ConfigurationService configurationService = cimInstance.getConfigurationService();
                List<ProjectDataObj> projects = configurationService.getProjects(new ProjectFilterSpecDataObj());
                for (ProjectDataObj project : projects) {
                    ArrayList<String> streamNames = new ArrayList<String>();
                    for (StreamDataObj stream : project.getStreams()) {
                        streamNames.add(stream.getId().getName());
                    }
                    Collections.sort(streamNames, String.CASE_INSENSITIVE_ORDER);
                    this.projectStreams.put(project.getId().getName(), streamNames);
                }
            }
            catch (IOException iOException) {
            }
            catch (CovRemoteServiceException_Exception covRemoteServiceException_Exception) {
                // empty catch block
            }
        }

        public List<String> getAvailableProjects() {
            ArrayList<String> projectNames = new ArrayList<String>(this.projectStreams.keySet());
            Collections.sort(projectNames, String.CASE_INSENSITIVE_ORDER);
            return projectNames;
        }

        public List<String> getStreamsForProject(String projectName) {
            if (this.projectStreams.containsKey(projectName)) {
                return this.projectStreams.get(projectName);
            }
            return new ArrayList<String>();
        }
    }
}

