/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.TaStripPath;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TaOptionBlock {
    private static final Logger logger = Logger.getLogger(CoverityPublisher.class.getName());
    private transient String taStripPath;
    private String customTestCommand;
    private boolean cOptionBlock;
    private boolean csOptionBlock;
    private String customTestTool;
    private String logFileLoc;
    private String csFramework;
    private String csCoverageTool;
    private String cxxCoverageTool;
    private String javaCoverageTool;
    private boolean junitFramework;
    private boolean junit4Framework;
    private final String policyFile;
    private String bullsEyeDir;
    private boolean covHistoryCheckbox;
    private boolean javaOptionBlock;
    private List<TaStripPath> taStripPaths;

    @DataBoundConstructor
    public TaOptionBlock(String policyFile) {
        this.policyFile = Util.fixEmpty((String)policyFile);
    }

    protected Object readResolve() {
        if (this.taStripPath != null) {
            logger.info("Old data format detected. Converting to new format.");
            this.convertTransientDataFields();
        }
        return this;
    }

    private void convertTransientDataFields() {
        TaStripPath stripPath = new TaStripPath(this.taStripPath);
        if (this.taStripPaths == null) {
            this.taStripPaths = new ArrayList<TaStripPath>();
        }
        this.taStripPaths.add(stripPath);
    }

    @DataBoundSetter
    public void setCustomTestCommand(String customTestCommand) {
        this.customTestCommand = Util.fixEmpty((String)customTestCommand);
    }

    public String getCustomTestCommand() {
        return this.customTestCommand;
    }

    @DataBoundSetter
    public void setcOptionBlock(boolean cOptionBlock) {
        this.cOptionBlock = cOptionBlock;
    }

    public boolean getcOptionBlock() {
        return this.cOptionBlock;
    }

    @DataBoundSetter
    public void setCsOptionBlock(boolean csOptionBlock) {
        this.csOptionBlock = csOptionBlock;
    }

    public boolean getCsOptionBlock() {
        return this.csOptionBlock;
    }

    @DataBoundSetter
    public void setJavaOptionBlock(boolean javaOptionBlock) {
        this.javaOptionBlock = javaOptionBlock;
    }

    public boolean getJavaOptionBlock() {
        return this.javaOptionBlock;
    }

    @DataBoundSetter
    public void setCustomTestTool(String customTestTool) {
        this.customTestTool = Util.fixEmpty((String)customTestTool);
    }

    public String getCustomTestTool() {
        return this.customTestTool;
    }

    @DataBoundSetter
    public void setLogFileLoc(String logFileLoc) {
        this.logFileLoc = Util.fixEmpty((String)logFileLoc);
    }

    public String getLogFileLoc() {
        return this.logFileLoc;
    }

    @DataBoundSetter
    public void setCsFramework(String csFramework) {
        this.csFramework = csFramework;
    }

    public String getCsFramework() {
        return this.csFramework;
    }

    @DataBoundSetter
    public void setCsCoverageTool(String csCoverageTool) {
        this.csCoverageTool = csCoverageTool;
    }

    public String getCsCoverageTool() {
        return this.csCoverageTool;
    }

    @DataBoundSetter
    public void setCxxCoverageTool(String cxxCoverageTool) {
        this.cxxCoverageTool = cxxCoverageTool;
    }

    public String getCxxCoverageTool() {
        return this.cxxCoverageTool;
    }

    @DataBoundSetter
    public void setJavaCoverageTool(String javaCoverageTool) {
        this.javaCoverageTool = javaCoverageTool;
    }

    public String getJavaCoverageTool() {
        return this.javaCoverageTool;
    }

    @DataBoundSetter
    public void setJunit4Framework(boolean junit4Framework) {
        this.junit4Framework = junit4Framework;
    }

    public boolean getJunit4Framework() {
        return this.junit4Framework;
    }

    @DataBoundSetter
    public void setJunitFramework(boolean junitFramework) {
        this.junitFramework = junitFramework;
    }

    public boolean getJunitFramework() {
        return this.junitFramework;
    }

    public String getPolicyFile() {
        return this.policyFile;
    }

    @DataBoundSetter
    public void setBullsEyeDir(String bullsEyeDir) {
        this.bullsEyeDir = bullsEyeDir;
    }

    public String getBullsEyeDir() {
        return this.bullsEyeDir;
    }

    @DataBoundSetter
    public void setCovHistoryCheckbox(boolean covHistoryCheckbox) {
        this.covHistoryCheckbox = covHistoryCheckbox;
    }

    public boolean getCovHistoryCheckbox() {
        return this.covHistoryCheckbox;
    }

    @DataBoundSetter
    public void setTaStripPaths(List<TaStripPath> taStripPaths) {
        this.taStripPaths = taStripPaths;
    }

    public List<TaStripPath> getTaStripPaths() {
        return this.taStripPaths;
    }

    public List<String> getTaCommandArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.cOptionBlock) {
            args.add("--c-coverage");
            if (!this.cxxCoverageTool.equals("none")) {
                args.add(this.cxxCoverageTool);
                if (this.cxxCoverageTool.equals("bullseye")) {
                    args.add("--bullseye-dir");
                    args.add(this.bullsEyeDir);
                }
            }
        }
        if (this.csOptionBlock) {
            args.add("--cs-coverage");
            if (!this.csCoverageTool.equals("none")) {
                args.add(this.csCoverageTool);
            }
            if (!this.csFramework.equals("none")) {
                args.add("--cs-test");
                args.add(this.csFramework);
            }
        }
        if (this.javaOptionBlock) {
            args.add("--java-coverage");
            if (!this.javaCoverageTool.equals("none")) {
                args.add(this.javaCoverageTool);
            }
            if (this.junitFramework) {
                args.add("--java-test");
                args.add("junit");
            }
            if (this.junit4Framework) {
                args.add("--java-test");
                args.add("junit4");
            }
        }
        return args;
    }

    public String checkTaConfig() {
        boolean delim = true;
        String errorText = "";
        if (!(this.javaOptionBlock || this.cOptionBlock || this.csOptionBlock)) {
            errorText = errorText + "[Test Advisor] No Coverage language was chosen, please pick at least one \n";
            delim = false;
        }
        if (StringUtils.isEmpty((String)this.policyFile)) {
            errorText = errorText + "[Test Advisor] Policy file is not specified. \n";
            delim = false;
        }
        if (this.javaOptionBlock && this.javaCoverageTool.equals("none") || this.cOptionBlock && this.cxxCoverageTool.equals("none") || this.csOptionBlock && this.csCoverageTool.equals("none")) {
            errorText = errorText + "[Test Advisor] No Coverage tool was chosen \n";
            delim = false;
        }
        if (this.cOptionBlock && this.cxxCoverageTool.equals("bullseye") && StringUtils.isEmpty((String)this.bullsEyeDir)) {
            errorText = errorText + "[Test Advisor] Bulls eye requires the installation directory. \n";
            delim = false;
        }
        if (delim) {
            errorText = "Pass";
        }
        return errorText;
    }
}

