/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.Util;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ScmOptionBlock {
    private final String scmSystem;
    private String customTestTool;
    private String scmToolArguments;
    private String scmCommandArgs;
    private String logFileLoc;
    private String p4Port;
    private String accRevRepo;
    private String scmAdditionalCmd;
    private String fileRegex;

    @DataBoundConstructor
    public ScmOptionBlock(String scmSystem) {
        this.scmSystem = scmSystem;
    }

    public String getScmSystem() {
        return this.scmSystem;
    }

    @DataBoundSetter
    public void setCustomTestTool(String customTestTool) {
        this.customTestTool = Util.fixEmpty((String)customTestTool);
    }

    public String getCustomTestTool() {
        return this.customTestTool;
    }

    @DataBoundSetter
    public void setScmToolArguments(String scmToolArguments) {
        this.scmToolArguments = Util.fixEmpty((String)scmToolArguments);
    }

    public String getScmToolArguments() {
        return this.scmToolArguments;
    }

    @DataBoundSetter
    public void setScmCommandArgs(String scmCommandArgs) {
        this.scmCommandArgs = Util.fixEmpty((String)scmCommandArgs);
    }

    public String getScmCommandArgs() {
        return this.scmCommandArgs;
    }

    @DataBoundSetter
    public void setLogFileLoc(String logFileLoc) {
        this.logFileLoc = Util.fixEmpty((String)logFileLoc);
    }

    public String getLogFileLoc() {
        return this.logFileLoc;
    }

    @DataBoundSetter
    public void setP4Port(String p4Port) {
        this.p4Port = Util.fixEmpty((String)p4Port);
    }

    public String getP4Port() {
        return this.p4Port;
    }

    @DataBoundSetter
    public void setAccRevRepo(String accRevRepo) {
        this.accRevRepo = Util.fixEmpty((String)accRevRepo);
    }

    public String getAccRevRepo() {
        return this.accRevRepo;
    }

    @DataBoundSetter
    public void setScmAdditionalCmd(String scmAdditionalCmd) {
        this.scmAdditionalCmd = Util.fixEmpty((String)scmAdditionalCmd);
    }

    public String getScmAdditionalCmd() {
        return this.scmAdditionalCmd;
    }

    @DataBoundSetter
    public void setFileRegex(String fileRegex) {
        this.fileRegex = Util.fixEmpty((String)fileRegex);
    }

    public String getFileRegex() {
        return this.fileRegex;
    }

    public String checkScmConfig() {
        String errorText = "";
        Boolean delim = true;
        if (this.scmSystem.equals("accurev") && StringUtils.isEmpty((String)this.accRevRepo)) {
            errorText = errorText + "[SCM] Please specify AccuRev's source control repository under 'Advanced' \n";
            delim = false;
        }
        if (this.scmSystem.equals("perforce") && StringUtils.isEmpty((String)this.p4Port)) {
            errorText = errorText + "[SCM] Please specify Perforce's port environment variable under 'Advanced'\n ";
            delim = false;
        }
        if (delim.booleanValue()) {
            errorText = "Pass";
        }
        return errorText;
    }
}

