/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import jenkins.plugins.coverity.SSLCertFileName;
import org.kohsuke.stapler.DataBoundConstructor;

public class SSLConfigurations {
    private transient String certFileName;
    private boolean trustNewSelfSignedCert;
    private SSLCertFileName sslCertFileName;

    @DataBoundConstructor
    public SSLConfigurations(boolean trustNewSelfSignedCert, SSLCertFileName sslCertFileName) {
        this.setTrustNewSelfSignedCert(trustNewSelfSignedCert);
        this.setCertFileName(sslCertFileName);
    }

    protected Object readResolve() {
        if (this.certFileName != null) {
            this.setCertFileName(new SSLCertFileName(this.certFileName));
        }
        return this;
    }

    public boolean isTrustNewSelfSignedCert() {
        return this.trustNewSelfSignedCert;
    }

    public void setTrustNewSelfSignedCert(boolean trustNewSelfSignedCert) {
        this.trustNewSelfSignedCert = trustNewSelfSignedCert;
    }

    public String getCertFileName() {
        return this.sslCertFileName != null ? this.sslCertFileName.getCertFileName() : null;
    }

    public void setCertFileName(SSLCertFileName sslCertFileName) {
        this.sslCertFileName = sslCertFileName;
    }
}

