/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.Util;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.coverity.JavaWarFile;
import jenkins.plugins.coverity.MisraConfig;
import jenkins.plugins.coverity.PostCovAnalyze;
import jenkins.plugins.coverity.PostCovBuild;
import jenkins.plugins.coverity.ToolsOverride;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class InvocationAssistance {
    private transient boolean isUsingMisra;
    private transient String misraConfigFile;
    private transient boolean isUsingPostCovBuildCmd;
    private transient String postCovBuildCmd;
    private transient boolean isUsingPostCovAnalyzeCmd;
    private transient String postCovAnalyzeCmd;
    private transient String saOverride;
    private String buildArguments;
    private String analyzeArguments;
    private String commitArguments;
    private List<String> javaWarFilesNames;
    private List<JavaWarFile> javaWarFiles;
    private boolean csharpMsvsca;
    private ToolsOverride toolsOverride;
    private MisraConfig misraConfig;
    private boolean isScriptSrc;
    private PostCovBuild postCovBuild;
    private PostCovAnalyze postCovAnalyze;
    private String intermediateDir;
    private boolean useAdvancedParser;

    @DataBoundConstructor
    public InvocationAssistance() {
    }

    protected Object readResolve() {
        if (this.isUsingMisra && this.misraConfigFile != null) {
            this.misraConfig = new MisraConfig(this.misraConfigFile);
        }
        if (this.isUsingPostCovBuildCmd && this.postCovBuildCmd != null) {
            this.postCovBuild = new PostCovBuild(this.postCovBuildCmd);
        }
        if (this.isUsingPostCovAnalyzeCmd && this.postCovAnalyzeCmd != null) {
            this.postCovAnalyze = new PostCovAnalyze(this.postCovAnalyzeCmd);
        }
        if (this.saOverride != null) {
            this.toolsOverride = new ToolsOverride(null);
            this.toolsOverride.setToolsLocation(this.saOverride);
            this.saOverride = null;
        }
        return this;
    }

    @DataBoundSetter
    public void setPostCovBuild(PostCovBuild postCovBuild) {
        this.postCovBuild = postCovBuild;
    }

    public String getPostCovBuildCmd() {
        return this.postCovBuild != null ? this.postCovBuild.getPostCovBuildCmd() : null;
    }

    public boolean getIsUsingPostCovBuildCmd() {
        return this.postCovBuild != null;
    }

    public boolean getIsUsingPostCovAnalyzeCmd() {
        return this.postCovAnalyze != null;
    }

    @DataBoundSetter
    public void setPostCovAnalyze(PostCovAnalyze postCovAnalyze) {
        this.postCovAnalyze = postCovAnalyze;
    }

    public String getPostCovAnalyzeCmd() {
        return this.postCovAnalyze != null ? this.postCovAnalyze.getPostCovAnalyzeCmd() : null;
    }

    @DataBoundSetter
    public void setIsScriptSrc(boolean isScriptSrc) {
        this.isScriptSrc = isScriptSrc;
    }

    public boolean getIsScriptSrc() {
        return this.isScriptSrc;
    }

    @DataBoundSetter
    public void setBuildArguments(String buildArguments) {
        this.buildArguments = Util.fixEmpty((String)buildArguments);
    }

    public String getBuildArguments() {
        return this.buildArguments;
    }

    @DataBoundSetter
    public void setAnalyzeArguments(String analyzeArguments) {
        this.analyzeArguments = Util.fixEmpty((String)analyzeArguments);
    }

    public String getAnalyzeArguments() {
        return this.analyzeArguments;
    }

    @DataBoundSetter
    public void setCommitArguments(String commitArguments) {
        this.commitArguments = Util.fixEmpty((String)commitArguments);
    }

    public String getCommitArguments() {
        return this.commitArguments;
    }

    @DataBoundSetter
    public void setIntermediateDir(String intermediateDir) {
        this.intermediateDir = Util.fixEmpty((String)intermediateDir);
    }

    public String getIntermediateDir() {
        return this.intermediateDir;
    }

    @DataBoundSetter
    public void setJavaWarFiles(List<JavaWarFile> javaWarFiles) {
        ArrayList<String> tempJavaWarFilesPaths = new ArrayList<String>();
        if (javaWarFiles != null && !javaWarFiles.isEmpty()) {
            for (JavaWarFile javaWarFile : javaWarFiles) {
                tempJavaWarFilesPaths.add(javaWarFile.getWarFile());
            }
        }
        this.javaWarFilesNames = tempJavaWarFilesPaths;
        this.javaWarFiles = javaWarFiles;
    }

    public List<JavaWarFile> getJavaWarFiles() {
        return this.javaWarFiles;
    }

    public List<String> getJavaWarFilesNames() {
        return this.javaWarFilesNames;
    }

    @DataBoundSetter
    public void setCsharpMsvsca(boolean csharpMsvsca) {
        this.csharpMsvsca = csharpMsvsca;
    }

    public boolean getCsharpMsvsca() {
        return this.csharpMsvsca;
    }

    @DataBoundSetter
    public void setToolsOverride(ToolsOverride toolsOverride) {
        this.toolsOverride = toolsOverride;
    }

    public ToolsOverride getToolsOverride() {
        return this.toolsOverride;
    }

    @DataBoundSetter
    public void setMisraConfig(MisraConfig misraConfig) {
        this.misraConfig = misraConfig;
    }

    public boolean getIsUsingMisra() {
        return this.misraConfig != null;
    }

    public String getMisraConfigFile() {
        return this.misraConfig != null ? this.misraConfig.getMisraConfigFile() : null;
    }

    @DataBoundSetter
    public void setUseAdvancedParser(boolean useAdvancedParser) {
        this.useAdvancedParser = useAdvancedParser;
    }

    public boolean getUseAdvancedParser() {
        return this.useAdvancedParser;
    }

    public InvocationAssistance merge(InvocationAssistance override) {
        ToolsOverride toolsOverrideOverride;
        String analyzeArguments = override.getAnalyzeArguments() != null ? override.getAnalyzeArguments() : this.getAnalyzeArguments();
        String buildArguments = override.getBuildArguments() != null ? override.getBuildArguments() : this.getBuildArguments();
        String commitArguments = override.getCommitArguments() != null ? override.getCommitArguments() : this.getCommitArguments();
        String intermediateDir = override.getIntermediateDir() != null ? override.getIntermediateDir() : this.getIntermediateDir();
        boolean csharpMsvsca = override.getCsharpMsvsca();
        if (override.saOverride != null) {
            toolsOverrideOverride = new ToolsOverride(null);
            toolsOverrideOverride.setToolsLocation(override.saOverride);
        } else {
            toolsOverrideOverride = this.toolsOverride;
        }
        MisraConfig misraConfig = override.isUsingMisra ? new MisraConfig(override.misraConfigFile) : null;
        boolean isScriptSrc = override.getIsScriptSrc();
        PostCovBuild postBuild = override.isUsingPostCovBuildCmd ? new PostCovBuild(override.postCovBuildCmd) : null;
        PostCovAnalyze postCovAnalyze = override.isUsingPostCovAnalyzeCmd ? new PostCovAnalyze(override.postCovAnalyzeCmd) : null;
        List<JavaWarFile> javaWarFiles = override.getJavaWarFiles();
        boolean useAdvancedParser = override.getUseAdvancedParser();
        InvocationAssistance invocationAssistance = new InvocationAssistance();
        invocationAssistance.setPostCovBuild(postBuild);
        invocationAssistance.setPostCovAnalyze(postCovAnalyze);
        invocationAssistance.setIsScriptSrc(isScriptSrc);
        invocationAssistance.setBuildArguments(buildArguments);
        invocationAssistance.setAnalyzeArguments(analyzeArguments);
        invocationAssistance.setCommitArguments(commitArguments);
        invocationAssistance.setIntermediateDir(intermediateDir);
        invocationAssistance.setMisraConfig(misraConfig);
        invocationAssistance.setJavaWarFiles(javaWarFiles);
        invocationAssistance.setCsharpMsvsca(csharpMsvsca);
        invocationAssistance.setToolsOverride(toolsOverrideOverride);
        invocationAssistance.setUseAdvancedParser(useAdvancedParser);
        return invocationAssistance;
    }

    public String checkIAConfig() {
        boolean delim = true;
        String errorText = "Errors with your \"Perform Coverity build/analyze/commit\" options: \n";
        if (this.getIsUsingMisra()) {
            if (this.getMisraConfigFile() == null) {
                delim = false;
            } else if (this.getMisraConfigFile().isEmpty()) {
                delim = false;
            } else if (this.getMisraConfigFile().trim().isEmpty()) {
                delim = false;
            }
        }
        errorText = delim ? "Pass" : errorText + "[Error] No MISRA configuration file was specified. \n";
        return errorText;
    }
}

