/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.EnvVars;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.coverity.ParseException;

public class EnvParser {
    public static List<String> tokenize(String input) throws ParseException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder tokenBuilder = new StringBuilder();
        State state = State.SPACE;
        Scanner scanner = new Scanner(input);
        while (scanner.get()) {
            char c = scanner.got();
            switch (state) {
                case NORMAL: {
                    if (c == '\"') {
                        state = State.DOUBLE_QUOTE;
                        break;
                    }
                    if (c == '\'') {
                        state = State.SINGLE_QUOTE;
                        break;
                    }
                    if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                        state = State.SPACE;
                        result.add(tokenBuilder.toString());
                        tokenBuilder = new StringBuilder();
                        break;
                    }
                    tokenBuilder.append(c);
                    break;
                }
                case SINGLE_QUOTE: {
                    if (c == '\'') {
                        state = State.NORMAL;
                        break;
                    }
                    tokenBuilder.append(c);
                    break;
                }
                case DOUBLE_QUOTE: {
                    if (c == '\"') {
                        state = State.NORMAL;
                        break;
                    }
                    tokenBuilder.append(c);
                    break;
                }
                case SPACE: {
                    if (c == '\"') {
                        state = State.DOUBLE_QUOTE;
                        tokenBuilder = new StringBuilder();
                        break;
                    }
                    if (c == '\'') {
                        state = State.SINGLE_QUOTE;
                        tokenBuilder = new StringBuilder();
                        break;
                    }
                    if (c == ' ' || c == '\n' || c == '\r' || c == '\t') break;
                    state = State.NORMAL;
                    tokenBuilder = new StringBuilder();
                    tokenBuilder.append(c);
                }
            }
        }
        switch (state) {
            case NORMAL: {
                String token = tokenBuilder.toString();
                if (token.isEmpty()) break;
                result.add(token);
                break;
            }
            case SINGLE_QUOTE: {
                throw new ParseException("Command line parsing failed: Unclosed double-quoted string.");
            }
            case DOUBLE_QUOTE: {
                throw new ParseException("Command line parsing failed: Unclosed single-quoted string.");
            }
        }
        return result;
    }

    public static List<String> tokenizeWithRuntimeException(String input) throws RuntimeException {
        try {
            return EnvParser.tokenize(input);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static boolean isFirstEnvVarChar(char c) {
        return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isEnvVarChar(char c) {
        return EnvParser.isFirstEnvVarChar(c) || c >= '0' && c <= '9';
    }

    /*
     * Unable to fully structure code
     */
    public static String interpolate(String input, EnvVars environment) throws ParseException {
        builder = new StringBuilder();
        state = State.NORMAL;
        scanner = new Scanner(input);
        block4: while (scanner.get()) {
            c = scanner.got();
            switch (1.$SwitchMap$jenkins$plugins$coverity$EnvParser$State[state.ordinal()]) {
                case 1: {
                    if (c != '$') ** GOTO lbl47
                    if (!scanner.get()) {
                        throw EnvParser.makeInterpolationException("Missing environment variable.");
                    }
                    c = scanner.got();
                    envVarNameBuilder = new StringBuilder();
                    if (c != '{') ** GOTO lbl27
                    c = scanner.hunt('}');
                    if (EnvParser.isFirstEnvVarChar(c)) {
                        envVarNameBuilder.append(c);
                    } else {
                        throw EnvParser.makeInterpolationException("Invalid first environment variable character: '" + c + "'.");
                    }
                    while ((c = scanner.hunt('}')) != '}') {
                        if (EnvParser.isEnvVarChar(c)) {
                            envVarNameBuilder.append(c);
                            continue;
                        }
                        throw EnvParser.makeInterpolationException("Invalid environment variable character: '" + c + "'.");
                    }
                    ** GOTO lbl40
lbl27:
                    // 1 sources

                    if (EnvParser.isFirstEnvVarChar(c)) {
                        envVarNameBuilder.append(c);
                    } else {
                        throw EnvParser.makeInterpolationException("Invalid first environment variable character: '" + c + "'.");
                    }
                    while (scanner.get()) {
                        c = scanner.got();
                        if (EnvParser.isEnvVarChar(c)) {
                            envVarNameBuilder.append(c);
                            continue;
                        }
                        scanner.unget();
                        break;
                    }
lbl40:
                    // 3 sources

                    if (envVarNameBuilder.length() == 0) {
                        throw EnvParser.makeInterpolationException("Empty environment variable name");
                    }
                    envValue = (String)environment.get((Object)envVarNameBuilder.toString());
                    if (envValue == null) continue block4;
                    builder.append(envValue);
                    break;
lbl47:
                    // 1 sources

                    if (c == '\'') {
                        state = State.SINGLE_QUOTE;
                        builder.append(c);
                        break;
                    }
                    builder.append(c);
                    break;
                }
                case 2: {
                    if (c == '\'') {
                        state = State.NORMAL;
                    }
                    builder.append(c);
                }
            }
        }
        if (!state.equals((Object)State.NORMAL)) {
            throw EnvParser.makeInterpolationException("Unterminated single-quoted string.");
        }
        return builder.toString();
    }

    private static ParseException makeInterpolationException(String reason) {
        return new ParseException("Error expanding environment variables: " + reason);
    }

    public static String interpolateRecursively(String input, int depth, EnvVars environment) throws ParseException {
        if (depth > 20) {
            throw new ParseException("Recursive environment variable referenced in \"" + input + "\"");
        }
        String interpolated = EnvParser.interpolate(input, environment);
        if (interpolated.equals(input)) {
            return input;
        }
        return EnvParser.interpolateRecursively(interpolated, depth + 1, environment);
    }

    private static class Scanner {
        private String input;
        private int index;
        private char next;

        public Scanner(String input) {
            this.input = input;
            this.index = 0;
        }

        public boolean get() {
            if (this.index < this.input.length()) {
                this.next = this.input.charAt(this.index++);
                return true;
            }
            return false;
        }

        public void unget() {
            --this.index;
        }

        public char got() {
            return this.next;
        }

        public char hunt(char sought) throws ParseException {
            if (!this.get()) {
                throw new ParseException("Parsing failed while seeking '" + sought + "'.");
            }
            return this.got();
        }
    }

    public static enum State {
        NORMAL,
        SINGLE_QUOTE,
        DOUBLE_QUOTE,
        SPACE;

    }
}

