/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v9.ComponentIdDataObj;
import com.coverity.ws.v9.MergedDefectFilterSpecDataObj;
import hudson.Util;
import hudson.model.Descriptor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DefectFilters {
    private List<String> classifications;
    private List<String> actions;
    private List<String> severities;
    private List<String> components;
    private List<String> ignoredComponents = new ArrayList<String>();
    private List<String> checkers;
    private List<String> ignoredCheckers = new ArrayList<String>();
    private Date cutOffDate;
    private List<String> impacts;

    @DataBoundConstructor
    public DefectFilters() {
    }

    @DataBoundSetter
    public void setCutOffDate(String cutOffDate) throws Descriptor.FormException {
        if ((cutOffDate = Util.fixEmpty((String)cutOffDate)) != null) {
            try {
                this.cutOffDate = new SimpleDateFormat("yyyy-MM-dd").parse(cutOffDate);
            }
            catch (ParseException e) {
                this.cutOffDate = null;
            }
        } else {
            this.cutOffDate = null;
        }
    }

    public String getCutOffDate() {
        if (this.cutOffDate == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.cutOffDate);
    }

    @DataBoundSetter
    public void setClassifications(List<String> classifications) {
        this.classifications = Util.fixNull(classifications);
    }

    public List<String> getClassifications() {
        return this.classifications;
    }

    @DataBoundSetter
    public void setActions(List<String> actions) {
        this.actions = Util.fixNull(actions);
    }

    public List<String> getActions() {
        return this.actions;
    }

    @DataBoundSetter
    public void setSeverities(List<String> severities) {
        this.severities = Util.fixNull(severities);
    }

    public List<String> getSeverities() {
        return this.severities;
    }

    @DataBoundSetter
    public void setImpacts(List<String> impacts) {
        this.impacts = Util.fixNull(impacts);
    }

    public List<String> getImpacts() {
        return this.impacts;
    }

    @DataBoundSetter
    public void setComponents(List<String> components) {
        this.components = Util.fixNull(components);
    }

    public List<String> getComponents() {
        return this.components;
    }

    public List<String> getIgnoredComponents() {
        return this.ignoredComponents;
    }

    public List<String> getIgnoredChecker() {
        return this.ignoredCheckers;
    }

    @DataBoundSetter
    public void setCheckers(List<String> checkers) {
        this.checkers = Util.fixNull(checkers);
    }

    public List<String> getCheckersList() {
        return this.checkers;
    }

    void initializeFilter(List<String> allCheckers, List<String> allClassifications, List<String> allActions, List<String> allSeverities, List<String> allComponents, List<String> allImpacts) {
        this.ignoredCheckers = new ArrayList<String>();
        this.checkers = new ArrayList<String>(allCheckers);
        this.actions = allActions;
        this.severities = allSeverities;
        this.ignoredComponents = new ArrayList<String>();
        this.components = allComponents;
        this.impacts = allImpacts;
        allClassifications.removeAll(Arrays.asList("Intentional", "False Positive", "No Test Needed", "Tested Elsewhere"));
        this.classifications = allClassifications;
    }

    public void invertCheckers(List<String> allCheckers) {
        this.ignoredCheckers = new ArrayList<String>(allCheckers);
        if (this.checkers != null) {
            this.ignoredCheckers.removeAll(this.checkers);
        }
    }

    public void invertComponents(List<String> allComponents) {
        this.ignoredComponents = new ArrayList<String>(allComponents);
        if (this.components != null) {
            this.ignoredComponents.removeAll(this.components);
        }
    }

    public boolean checkConfig() {
        return this.getCheckersList() != null && this.getClassifications() != null && this.getActions() != null && this.getSeverities() != null && this.getComponents() != null;
    }

    public boolean isClassificationSelected(String action) {
        return this.classifications != null && this.classifications.contains(action);
    }

    public boolean isActionSelected(String action) {
        return this.actions != null && this.actions.contains(action);
    }

    public boolean isImpactsSelected(String impact) {
        if (this.impacts == null) {
            return false;
        }
        HashMap<String, String> mapWithJapaneseTranslations = new HashMap<String, String>();
        mapWithJapaneseTranslations.put("High", "\u9ad8");
        mapWithJapaneseTranslations.put("Medium", "\u4e2d");
        mapWithJapaneseTranslations.put("Low", "\u4f4e");
        ArrayList<String> initialImpacts = new ArrayList<String>(this.impacts);
        if (initialImpacts != null && !initialImpacts.isEmpty()) {
            for (String specificImpact : initialImpacts) {
                if (!mapWithJapaneseTranslations.containsKey(specificImpact)) continue;
                this.impacts.add((String)mapWithJapaneseTranslations.get(specificImpact));
            }
        }
        return this.impacts.contains(impact);
    }

    public boolean isSeveritySelected(String severity) {
        return this.severities != null && this.severities.contains(severity);
    }

    public boolean isComponentSelected(String component) {
        return this.ignoredComponents != null && !this.ignoredComponents.contains(component);
    }

    public boolean isCheckerSelected(String checker) {
        return this.ignoredCheckers != null && !this.ignoredCheckers.contains(checker);
    }

    public XMLGregorianCalendar getXMLCutOffDate() {
        if (this.cutOffDate != null) {
            GregorianCalendar calender = new GregorianCalendar();
            calender.setTime(this.cutOffDate);
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(calender);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public MergedDefectFilterSpecDataObj ToFilterSpecDataObj() {
        XMLGregorianCalendar xmlCutOffDate;
        MergedDefectFilterSpecDataObj filterSpecDataObj = new MergedDefectFilterSpecDataObj();
        filterSpecDataObj.getActionNameList().addAll(this.actions);
        filterSpecDataObj.getClassificationNameList().addAll(this.classifications);
        filterSpecDataObj.getSeverityNameList().addAll(this.severities);
        filterSpecDataObj.getImpactList().addAll(this.impacts);
        if (this.components != null) {
            for (String component : this.components) {
                ComponentIdDataObj componentIdDataObj = new ComponentIdDataObj();
                componentIdDataObj.setName(component);
                filterSpecDataObj.getComponentIdList().add(componentIdDataObj);
            }
        }
        if (this.checkers != null) {
            filterSpecDataObj.getCheckerList().addAll(this.checkers);
        }
        if ((xmlCutOffDate = this.getXMLCutOffDate()) != null) {
            filterSpecDataObj.setFirstDetectedStartDate(xmlCutOffDate);
        }
        return filterSpecDataObj;
    }
}

