/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CoverityBuildAction;
import jenkins.plugins.coverity.CoverityViewResultsDescriptor;
import jenkins.plugins.coverity.ws.ViewIssuesReader;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CoverityViewResultsPublisher
extends Recorder
implements SimpleBuildStep {
    private String connectInstance;
    private String connectView;
    private String projectId;
    private boolean failPipeline;
    private boolean unstable;

    @DataBoundConstructor
    public CoverityViewResultsPublisher(String connectInstance, String connectView, String projectId) {
        this.connectInstance = connectInstance;
        this.connectView = connectView;
        this.projectId = projectId;
        this.failPipeline = false;
        this.unstable = false;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) {
        PrintStream logger = listener.getLogger();
        logger.println("[Coverity] Publish Coverity View Results { connectInstance:'" + this.connectInstance + "', projectId:'" + this.projectId + "', connectView:'" + this.connectView + "}");
        CIMInstance instance = this.getInstance();
        if (instance == null) {
            logger.println("[Coverity] Unable to find Coverity Connect instance: " + this.connectInstance);
            run.setResult(Result.FAILURE);
            return;
        }
        if (StringUtils.isEmpty((String)this.projectId) || StringUtils.isEmpty((String)this.connectView)) {
            logger.println("[Coverity] Coverity Connect project and view are required. But was Project: '" + this.projectId + "' View: '" + this.connectView + "'");
            run.setResult(Result.FAILURE);
            return;
        }
        try {
            ViewIssuesReader reader = new ViewIssuesReader(run, listener.getLogger(), this);
            reader.getIssuesFromConnectView();
            CoverityBuildAction buildAction = (CoverityBuildAction)run.getAction(CoverityBuildAction.class);
            if (this.failPipeline && buildAction.getDefects().size() > 0) {
                run.setResult(Result.FAILURE);
            } else if (this.unstable && buildAction.getDefects().size() > 0) {
                run.setResult(Result.UNSTABLE);
            }
        }
        catch (Exception e) {
            logger.println("[Coverity] Error Publishing Coverity View Results");
            logger.println(e.toString());
            run.setResult(Result.FAILURE);
        }
        logger.println("[Coverity] Finished Publishing Coverity View Results");
    }

    public CIMInstance getInstance() {
        return this.getDescriptor().getInstance(this.connectInstance);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getConnectInstance() {
        return this.connectInstance;
    }

    @DataBoundSetter
    public void setConnectInstance(String connectInstance) {
        this.connectInstance = Util.fixNull((String)connectInstance);
    }

    public String getConnectView() {
        return this.connectView;
    }

    @DataBoundSetter
    public void setConnectView(String connectView) {
        this.connectView = Util.fixNull((String)connectView);
    }

    public CoverityViewResultsDescriptor getDescriptor() {
        return (CoverityViewResultsDescriptor)super.getDescriptor();
    }

    public String getProjectId() {
        return this.projectId;
    }

    @DataBoundSetter
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public boolean isFailPipeline() {
        return this.failPipeline;
    }

    @DataBoundSetter
    public void setFailPipeline(boolean failPipeline) {
        this.failPipeline = failPipeline;
    }

    public boolean isUnstable() {
        return this.unstable;
    }

    @DataBoundSetter
    public void setUnstable(boolean unstable) {
        this.unstable = unstable;
    }
}

