/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v9.CovRemoteServiceException_Exception;
import com.coverity.ws.v9.ProjectDataObj;
import com.coverity.ws.v9.ProjectFilterSpecDataObj;
import com.google.common.collect.ImmutableSortedMap;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityViewResultsPublisher;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;

@Symbol(value={"coverityResults"})
@Extension
public class CoverityViewResultsDescriptor
extends BuildStepDescriptor<Publisher> {
    public CoverityViewResultsDescriptor() {
        super(CoverityViewResultsPublisher.class);
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getDisplayName() {
        return "Publish Coverity View Results";
    }

    private CoverityPublisher.DescriptorImpl getPublisherDescriptor() {
        return (CoverityPublisher.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(CoverityPublisher.DescriptorImpl.class);
    }

    private List<CIMInstance> getConnectInstances() {
        return this.getPublisherDescriptor().getInstances();
    }

    public CIMInstance getInstance(String name) {
        for (CIMInstance instance : this.getConnectInstances()) {
            if (!instance.getName().equals(name)) continue;
            return instance;
        }
        return null;
    }

    public ListBoxModel doFillConnectInstanceItems() {
        ListBoxModel result = new ListBoxModel();
        for (CIMInstance instance : this.getConnectInstances()) {
            result.add(instance.getName());
        }
        return result;
    }

    public FormValidation doCheckViews(@QueryParameter String connectInstance, @QueryParameter String projectId, @QueryParameter String connectView) {
        ArrayList<FormValidation> validations;
        block19: {
            validations = new ArrayList<FormValidation>();
            if (StringUtils.isEmpty((String)connectInstance)) {
                validations.add(FormValidation.error((String)"Coverity Connect Instance is required"));
            }
            if (StringUtils.isEmpty((String)projectId)) {
                validations.add(FormValidation.error((String)"Coverity Connect Project is required"));
            }
            if (StringUtils.isEmpty((String)connectView)) {
                validations.add(FormValidation.error((String)"Coverity Connect View is required"));
            }
            if (validations.size() > 0) {
                return FormValidation.aggregate(validations);
            }
            CIMInstance instance = this.getInstance(connectInstance);
            if (instance == null) {
                return FormValidation.error((String)("Unable to find Coverity Connect instance: " + connectInstance));
            }
            FormValidation instanceCheck = instance.doCheck();
            if (!instanceCheck.kind.equals((Object)FormValidation.Kind.OK)) {
                return instanceCheck;
            }
            try {
                ProjectFilterSpecDataObj projectFilterSpec = new ProjectFilterSpecDataObj();
                projectFilterSpec.setIncludeChildren(false);
                projectFilterSpec.setIncludeStreams(false);
                projectFilterSpec.setNamePattern(projectId);
                List<ProjectDataObj> projects = instance.getConfigurationService().getProjects(projectFilterSpec);
                if (projects.size() != 1) {
                    StringBuilder missingProjectMessage = new StringBuilder();
                    missingProjectMessage.append("Unable to find project '" + projectId + "' on instance '" + connectInstance + "'.");
                    projectFilterSpec.setNamePattern(null);
                    projects = instance.getConfigurationService().getProjects(projectFilterSpec);
                    if (projects.size() > 0) {
                        missingProjectMessage.append(" Available projects include: ");
                        for (ProjectDataObj project : projects) {
                            missingProjectMessage.append(project.getId().getName());
                            missingProjectMessage.append(", ");
                        }
                        missingProjectMessage.delete(missingProjectMessage.length() - 2, missingProjectMessage.length());
                    }
                    validations.add(FormValidation.error((String)missingProjectMessage.toString()));
                }
            }
            catch (CovRemoteServiceException_Exception | IOException e) {
                return FormValidation.error((String)"Unexpected error occurred when checking project");
            }
            try {
                ImmutableSortedMap<Long, String> views = instance.getViews();
                if (views.containsValue((Object)connectView)) break block19;
                Long connectViewIdentifier = null;
                try {
                    connectViewIdentifier = Long.parseLong(connectView);
                }
                catch (NumberFormatException missingProjectMessage) {
                    // empty catch block
                }
                if (!views.containsKey((Object)connectViewIdentifier)) {
                    StringBuilder missingViewMessage = new StringBuilder();
                    missingViewMessage.append("Unable to find the view '" + connectView + "' on instance '" + connectInstance + "'.");
                    if (views.size() > 0) {
                        missingViewMessage.append(" Available views include: ");
                        for (String viewName : views.values()) {
                            missingViewMessage.append(viewName);
                            missingViewMessage.append(", ");
                        }
                        missingViewMessage.delete(missingViewMessage.length() - 2, missingViewMessage.length());
                    }
                    validations.add(FormValidation.error((String)missingViewMessage.toString()));
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Unexpected error occurred when checking views");
            }
        }
        if (validations.size() > 0) {
            return FormValidation.aggregate(validations);
        }
        return FormValidation.ok((String)"Successfully configured");
    }
}

