/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class CoverityVersion
implements Comparable<CoverityVersion>,
Serializable {
    public static final CoverityVersion VERSION_JASPER = new CoverityVersion(8, 0, 0, 0);
    public static final CoverityVersion VERSION_JASPER1 = new CoverityVersion(8, 1, 0, 0);
    public static final CoverityVersion MINIMUM_SUPPORTED_VERSION = VERSION_JASPER;
    final int major;
    final int minor;
    final int patch;
    final int hotfix;
    private boolean isSrmVersion;
    private String srmVersion;

    public CoverityVersion(int major, int minor, int patch, int hotfix) {
        this.isSrmVersion = false;
        this.hotfix = hotfix;
        this.minor = minor;
        this.patch = patch;
        this.major = major;
    }

    public CoverityVersion(int major, int minor) {
        this.hotfix = 0;
        this.patch = 0;
        this.major = major;
        this.minor = minor;
    }

    public static CoverityVersion parse(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return null;
        }
        String[] parts = s.split("\\.");
        if (parts.length == 2) {
            String[] srmParts = parts[1].split("-SP|-");
            CoverityVersion srmVersion = srmParts.length == 2 ? new CoverityVersion(Integer.parseInt(parts[0]), Integer.parseInt(srmParts[0]), Integer.parseInt(srmParts[1]), 0) : (srmParts.length == 3 ? new CoverityVersion(Integer.parseInt(parts[0]), Integer.parseInt(srmParts[0]), Integer.parseInt(srmParts[1]), Integer.parseInt(srmParts[2])) : new CoverityVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1])));
            srmVersion.isSrmVersion = true;
            srmVersion.srmVersion = s;
            return srmVersion;
        }
        if (parts.length == 3) {
            return new CoverityVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), 0);
        }
        if (parts.length == 4) {
            return new CoverityVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
        }
        return null;
    }

    public String toString() {
        if (this.isSrmVersion && !StringUtils.isEmpty((String)this.srmVersion)) {
            return this.srmVersion;
        }
        return this.major + "." + this.minor + "." + this.patch + (this.hotfix > 0 ? "." + this.hotfix : "");
    }

    @Override
    public int compareTo(CoverityVersion o) {
        if (this.major == o.major) {
            if (this.minor == o.minor) {
                if (this.patch == o.patch) {
                    return this.cmp(this.hotfix, o.hotfix);
                }
                return this.cmp(this.patch, o.patch);
            }
            return this.cmp(this.minor, o.minor);
        }
        return this.cmp(this.major, o.major);
    }

    public boolean compareToAnalysis(CoverityVersion version) {
        if (this.major == version.major) {
            return this.minor >= version.minor;
        }
        return this.major > version.major;
    }

    private int cmp(int a, int b) {
        return a < b ? -1 : (a == b ? 0 : 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoverityVersion other = (CoverityVersion)o;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        if (this.patch != other.patch) {
            return false;
        }
        return this.hotfix == other.hotfix;
    }

    public int hashCode() {
        int result = 31;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + this.hotfix;
        return result;
    }
}

