/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.coverity.CoverityInstallation;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityToolInstallation;
import jenkins.plugins.coverity.EnvParser;
import jenkins.plugins.coverity.InvocationAssistance;
import jenkins.plugins.coverity.ParseException;
import jenkins.plugins.coverity.ToolsOverride;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class CoverityUtils {
    private static final Logger logger = Logger.getLogger(CoverityUtils.class.getName());

    public static String evaluateEnvVars(String input, EnvVars environment, boolean useAdvancedParser) throws RuntimeException {
        try {
            if (useAdvancedParser) {
                String interpolated = EnvParser.interpolateRecursively(input, 1, environment);
                return interpolated;
            }
            return environment.expand(input);
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to evaluate environment variable: " + input);
        }
    }

    public static void checkDir(VirtualChannel channel, String home) throws Exception {
        Validate.notNull((Object)channel, (String)(VirtualChannel.class.getName() + " object can't be null"));
        Validate.notNull((Object)home, (String)(String.class.getName() + " object can't be null"));
        FilePath homePath = new FilePath(channel, home);
        if (!homePath.exists()) {
            throw new Exception("Directory: " + home + " doesn't exist.");
        }
    }

    public static String getCovBuild(TaskListener listener, Node node) {
        if (listener == null) {
            logger.warning("Listener used by getCovBuild() is null.");
            return null;
        }
        try {
            String covBuild = "cov-build";
            AbstractBuild build = CoverityUtils.getBuild();
            CoverityToolInstallation toolInstallation = CoverityUtils.findToolInstallationForBuild(node, build.getEnvironment(listener), listener);
            if (toolInstallation != null && StringUtils.isNotEmpty((String)toolInstallation.getHome())) {
                CoverityUtils.checkDir(node.getChannel(), toolInstallation.getHome());
                covBuild = new FilePath(node.getChannel(), toolInstallation.getHome()).child("bin").child(covBuild).getRemote();
                return covBuild;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static CoverityToolInstallation findToolInstallationForBuild(Node node, EnvVars environment, TaskListener listener) {
        AbstractBuild build = CoverityUtils.getBuild();
        AbstractProject project = build.getProject();
        CoverityPublisher publisher = (CoverityPublisher)project.getPublishersList().get(CoverityPublisher.class);
        if (publisher == null) {
            logger.warning("CoverityPublisher is null, cannot find Coverity Analysis installation for build.");
            return null;
        }
        FilePath coverityToolInstallations = publisher.getDescriptor().getInstallations();
        try {
            Object installation;
            CoverityInstallation nodeInstall;
            ToolsOverride toolsOverride;
            InvocationAssistance invocationAssistance = publisher.getInvocationAssistance();
            if (invocationAssistance != null && (toolsOverride = invocationAssistance.getToolsOverride()) != null) {
                String toolName = StringUtils.isNotEmpty((String)toolsOverride.getToolInstallationName()) ? toolsOverride.getToolInstallationName() : "default";
                FilePath filePath = coverityToolInstallations;
                int n = ((CoverityToolInstallation[])filePath).length;
                for (int i = 0; i < n; ++i) {
                    FilePath installation2 = filePath[i];
                    if (!toolName.equalsIgnoreCase(installation2.getName())) continue;
                    if (StringUtils.isNotEmpty((String)toolsOverride.getToolsLocation())) {
                        String overrideToolsLocation = CoverityUtils.evaluateEnvVars(toolsOverride.getToolsLocation(), environment, invocationAssistance.getUseAdvancedParser());
                        CoverityToolInstallation installOverride = new CoverityToolInstallation(installation2.getName() + "-" + "job-override", overrideToolsLocation);
                        logger.info("Found tools installation '" + installation2.getName() + "' with directory '" + installation2.getHome() + "' from Job tools override (with optional location override).");
                        return installOverride.forEnvironment(environment);
                    }
                    logger.info("Found tools installation '" + installation2.getName() + "' with directory '" + installation2.getHome() + "' from Job tools override.");
                    return (CoverityToolInstallation)installation2.translate(node, environment, listener);
                }
                String warnMsg = "Attempted to use Job tools override with Coverity Static Analysis tools installation '" + toolName + "', but was not found, will continue to try to find alternate installation";
                logger.warning(warnMsg);
                listener.getLogger().println("[Coverity] Warning: " + warnMsg);
            }
            if ((nodeInstall = (CoverityInstallation)node.getNodeProperties().get(CoverityInstallation.class)) != null) {
                FilePath nodePath = null;
                String nodeInstallHome = nodeInstall.getHome();
                if (StringUtils.isNotEmpty((String)nodeInstallHome)) {
                    nodePath = new FilePath(node.getChannel(), nodeInstallHome);
                }
                if (nodePath != null && nodePath.exists()) {
                    CoverityToolInstallation install = new CoverityToolInstallation("job-override", nodeInstallHome);
                    logger.info("Found tools installation '" + install.getName() + "' with directory '" + install.getHome() + "' from Node property");
                    return install.forEnvironment(environment);
                }
                String warnMsg = "Attempted to use path to Coverity Static Analysis directory '" + nodePath + "' from '" + node.getDisplayName() + "' node property. The path was not found, will continue to try to find alternate installation.";
                logger.warning(warnMsg);
                listener.getLogger().println("[Coverity] Warning: " + warnMsg);
            }
            for (CoverityToolInstallation installation3 : coverityToolInstallations) {
                if (!"default".equalsIgnoreCase(installation3.getName())) continue;
                logger.info("Found tools installation '" + installation3.getName() + "' with directory '" + installation3.getHome() + "' from default installation");
                return (CoverityToolInstallation)installation3.translate(node, environment, listener);
            }
            if (((CoverityToolInstallation[])coverityToolInstallations).length > 0) {
                installation = coverityToolInstallations[0];
                logger.info("Found tools installation '" + installation.getName() + "' with directory '" + installation.getHome() + "' from first fallback installation");
                return (CoverityToolInstallation)installation.translate(node, environment, listener);
            }
            if (publisher.getDescriptor().getHome() != null) {
                installation = new CoverityToolInstallation("global", publisher.getDescriptor().getHome());
                logger.info("Found tools installation '" + installation.getName() + "' with directory '" + installation.getHome() + "' from existing global configuration");
                return (CoverityToolInstallation)installation.translate(node, environment, listener);
            }
        }
        catch (IOException | InterruptedException e) {
            logger.log(Level.WARNING, "Error occurred getting Coverity Analysis installation", e);
        }
        return null;
    }

    public static List<String> expand(String input, EnvVars environment) throws ParseException {
        ArrayList<String> output = new ArrayList<String>();
        String interpolated = EnvParser.interpolateRecursively(input, 1, environment);
        output.addAll(EnvParser.tokenize(interpolated));
        return output;
    }

    public static List<String> evaluateEnvVars(List<String> input, EnvVars environment) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            for (String arg : input) {
                output.addAll(CoverityUtils.expand(arg, environment));
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
        return output;
    }

    public static String getStackTrace(Exception e) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        printWriter.flush();
        String stackTrace = writer.toString();
        try {
            writer.close();
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stackTrace;
    }

    public static void handleException(String message, AbstractBuild<?, ?> build, BuildListener listener, Exception exception) {
        listener.getLogger().println(message);
        listener.getLogger().println("Stacktrace: \n" + CoverityUtils.getStackTrace(exception));
        build.setResult(Result.FAILURE);
    }

    public static void handleException(String message, AbstractBuild<?, ?> build, TaskListener listener, Exception exception) {
        listener.getLogger().println(message);
        listener.getLogger().println("Stacktrace: \n" + CoverityUtils.getStackTrace(exception));
        build.setResult(Result.FAILURE);
    }

    public static List<String> prepareCmds(List<String> input, String[] envVarsArray, boolean useAdvancedParser) {
        if (useAdvancedParser) {
            EnvVars envVars = new EnvVars(CoverityUtils.arrayToMap(envVarsArray));
            return CoverityUtils.evaluateEnvVars(input, envVars);
        }
        return input;
    }

    public static List<String> prepareCmds(List<String> input, EnvVars envVars, boolean useAdvancedParser) {
        if (useAdvancedParser) {
            return CoverityUtils.evaluateEnvVars(input, envVars);
        }
        return input;
    }

    public static Map<String, String> arrayToMap(String[] input) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < input.length; ++i) {
            List<String> keyValuePair = CoverityUtils.splitKeyValue(input[i]);
            if (keyValuePair == null || keyValuePair.isEmpty()) continue;
            String key = keyValuePair.get(0);
            String value = keyValuePair.get(1);
            result.put(key, value);
        }
        return result;
    }

    public static List<String> splitKeyValue(String input) {
        if (input == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int index = input.indexOf(61);
        if (index == 0) {
            logger.warning("Could not parse environment variable \"" + input + "\" because its key is empty.");
        } else if (index < 0) {
            logger.warning("Could not parse environment variable \"" + input + "\" because no value for it has been defined.");
        } else if (index == input.length() - 1) {
            logger.warning("Could not parse environment variable \"" + input + "\" because the value for it is empty.");
        } else {
            String key = input.substring(0, index);
            String value = input.substring(index + 1);
            result.add(key);
            result.add(value);
        }
        return result;
    }

    public static InvocationAssistance getInvocationAssistance(AbstractBuild<?, ?> build) {
        AbstractProject project = build.getProject();
        CoverityPublisher publisher = (CoverityPublisher)project.getPublishersList().get(CoverityPublisher.class);
        return publisher != null ? publisher.getInvocationAssistance() : null;
    }

    public static InvocationAssistance getInvocationAssistance() {
        AbstractBuild build = CoverityUtils.getBuild();
        return CoverityUtils.getInvocationAssistance(build);
    }

    public static String[] addEnvVars(String[] envVarsArray, EnvVars envVars) {
        EnvVars resultMap = new EnvVars(envVars);
        resultMap.putAll(CoverityUtils.arrayToMap(envVarsArray));
        String[] r = new String[resultMap.size()];
        int idx = 0;
        for (Map.Entry e : resultMap.entrySet()) {
            r[idx++] = (String)e.getKey() + '=' + (String)e.getValue();
        }
        return r;
    }

    public static int runCmd(List<String> cmd, AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, EnvVars envVars, boolean useAdvancedParser) throws IOException, InterruptedException {
        String[] launcherEnvVars = launcher.launch().envs();
        launcherEnvVars = CoverityUtils.addEnvVars(launcherEnvVars, envVars);
        cmd = CoverityUtils.prepareCmds(cmd, launcherEnvVars, useAdvancedParser);
        int result = launcher.launch().cmds(new ArgumentListBuilder(cmd.toArray(new String[cmd.size()]))).pwd(build.getWorkspace()).stdout(listener).stderr((OutputStream)listener.getLogger()).envs(launcherEnvVars).join();
        return result;
    }

    public static AbstractBuild getBuild() {
        Executor executor = Executor.currentExecutor();
        Queue.Executable exec = executor.getCurrentExecutable();
        AbstractBuild build = (AbstractBuild)exec;
        return build;
    }

    public static String doubleQuote(String input, boolean useAdvancedParser) {
        if (useAdvancedParser) {
            return "\"" + input + "\"";
        }
        return input;
    }

    public static EnvVars getBuildEnvVars(TaskListener listener) {
        AbstractBuild build = CoverityUtils.getBuild();
        EnvVars envVars = null;
        try {
            envVars = build.getEnvironment(listener);
        }
        catch (Exception e) {
            CoverityUtils.handleException(e.getMessage(), build, listener, e);
        }
        return envVars;
    }

    public static Collection<File> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        Vector<File> files = new Vector<File>();
        if (directory == null) {
            return files;
        }
        File[] entries = directory.listFiles();
        if (entries == null) {
            return files;
        }
        for (File entry : entries) {
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(CoverityUtils.listFiles(entry, filter, recurse));
        }
        return files;
    }
}

