/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.tools.ToolPropertyDescriptor;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.coverity.CheckConfig;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityVersion;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class CoverityToolInstallation
extends ToolInstallation
implements NodeSpecific<CoverityToolInstallation>,
EnvironmentSpecific<CoverityToolInstallation> {
    public static final String DEFAULT_NAME = "default";
    public static final String JOB_OVERRIDE_NAME = "job-override";

    @DataBoundConstructor
    public CoverityToolInstallation(String name, String home) {
        super(name, home, (List)new DescribableList(Saveable.NOOP));
    }

    public CoverityToolInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new CoverityToolInstallation(this.getName(), this.translateFor(node, log));
    }

    public CoverityToolInstallation forEnvironment(EnvVars environment) {
        return new CoverityToolInstallation(this.getName(), environment.expand(this.getHome()));
    }

    public void buildEnvVars(EnvVars env) {
        String home = this.getHome();
        if (home != null) {
            env.put("PATH+COVERITY", home + "/bin");
        }
    }

    @Extension
    @Symbol(value={"coverity"})
    public static final class CoverityToolInstallationDescriptor
    extends ToolDescriptor<CoverityToolInstallation> {
        public String getDisplayName() {
            return "Coverity Static Analysis Tools";
        }

        public List<ToolPropertyDescriptor> getPropertyDescriptors() {
            return Collections.emptyList();
        }

        public DescribableList<ToolProperty<?>, ToolPropertyDescriptor> getDefaultProperties() {
            return new DescribableList(NOOP);
        }

        public CoverityToolInstallation[] getInstallations() {
            return this.getDescriptor().getInstallations();
        }

        public void setInstallations(CoverityToolInstallation ... installations) {
            this.getDescriptor().setInstallations(installations);
        }

        private CoverityPublisher.DescriptorImpl getDescriptor() {
            return (CoverityPublisher.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(CoverityPublisher.DescriptorImpl.class);
        }

        protected FormValidation checkHomeDirectory(File home) {
            try {
                File analysisVersionXml = new File(home, "VERSION.xml");
                if (home != null && home.exists()) {
                    if (analysisVersionXml.isFile()) {
                        CoverityVersion version = CheckConfig.getVersion(new FilePath(home));
                        if (version.compareTo(CoverityVersion.MINIMUM_SUPPORTED_VERSION) < 0) {
                            return FormValidation.error((String)("Analysis version " + version.toString() + " detected. The minimum supported version is " + CoverityVersion.MINIMUM_SUPPORTED_VERSION.toString()));
                        }
                        return FormValidation.ok((String)"Analysis installation directory has been verified.");
                    }
                    return FormValidation.error((String)"The specified Analysis installation directory doesn't contain a VERSION.xml file.");
                }
                return FormValidation.error((String)"The specified Analysis installation directory doesn't exists.");
            }
            catch (IOException | InterruptedException e) {
                return FormValidation.error((String)"Unable to verify the Analysis installation directory.");
            }
        }
    }
}

