/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTool.Command;
import jenkins.plugins.coverity.EnvParser;
import jenkins.plugins.coverity.InvocationAssistance;
import jenkins.plugins.coverity.ParseException;
import org.apache.commons.lang.StringUtils;

public class PostCovBuildCommand
extends Command {
    public PostCovBuildCommand(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, CoverityPublisher publisher, EnvVars envVars) {
        super(build, launcher, listener, publisher, envVars);
    }

    @Override
    protected void prepareCommand() {
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        try {
            String postCovBuildCmd = invocationAssistance.getPostCovBuildCmd();
            if (!StringUtils.isEmpty((String)postCovBuildCmd)) {
                this.addArguments(EnvParser.tokenize(postCovBuildCmd));
            }
            this.listener.getLogger().println("[Coverity] post cov-build command: " + this.commandLine.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException("ParseException occurred during tokenizing the post cov-build command.");
        }
    }

    @Override
    protected boolean canExecute() {
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        if (invocationAssistance == null || !invocationAssistance.getIsUsingPostCovBuildCmd()) {
            return false;
        }
        if (StringUtils.isEmpty((String)invocationAssistance.getPostCovBuildCmd())) {
            this.listener.getLogger().println("[Coverity] Post cov-build command is empty. Skipping post cov-build step");
            return false;
        }
        return true;
    }
}

