/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTool.Command;
import jenkins.plugins.coverity.EnvParser;
import jenkins.plugins.coverity.InvocationAssistance;
import jenkins.plugins.coverity.ParseException;
import org.apache.commons.lang.StringUtils;

public class PostCovAnalyzeCommand
extends Command {
    public PostCovAnalyzeCommand(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, CoverityPublisher publisher, EnvVars envVars) {
        super(build, launcher, listener, publisher, envVars);
    }

    @Override
    protected void prepareCommand() {
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        try {
            String postCovAnalyzeCmd = invocationAssistance.getPostCovAnalyzeCmd();
            if (!StringUtils.isEmpty((String)postCovAnalyzeCmd)) {
                this.addArguments(EnvParser.tokenize(postCovAnalyzeCmd));
                this.listener.getLogger().println("[Coverity] post cov-analyze command line arguments: " + this.commandLine.toString());
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("ParseException occurred during tokenizing the post cov-analyze command.");
        }
    }

    @Override
    protected boolean canExecute() {
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        if (invocationAssistance == null || !invocationAssistance.getIsUsingPostCovAnalyzeCmd()) {
            return false;
        }
        if (StringUtils.isEmpty((String)invocationAssistance.getPostCovAnalyzeCmd())) {
            this.listener.getLogger().println("[Coverity] Post cov-analyze command is empty. Skipping post cov-analyze step");
            return false;
        }
        return true;
    }
}

