/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CIMStream;
import jenkins.plugins.coverity.CoverityLauncherDecorator;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTempDir;
import jenkins.plugins.coverity.CoverityTool.CovAnalyzeCommand;
import jenkins.plugins.coverity.CoverityTool.CovBuildScriptCommand;
import jenkins.plugins.coverity.CoverityTool.CovCaptureCommand;
import jenkins.plugins.coverity.CoverityTool.CovCommitDefectsCommand;
import jenkins.plugins.coverity.CoverityTool.CovEmitJavaCommand;
import jenkins.plugins.coverity.CoverityTool.CovImportMsvscaCommand;
import jenkins.plugins.coverity.CoverityTool.CovImportScmCommand;
import jenkins.plugins.coverity.CoverityTool.CovManageHistoryCommand;
import jenkins.plugins.coverity.CoverityTool.PostCovAnalyzeCommand;
import jenkins.plugins.coverity.CoverityTool.PostCovBuildCommand;
import jenkins.plugins.coverity.CoverityToolInstallation;
import jenkins.plugins.coverity.CoverityUtils;
import jenkins.plugins.coverity.InvocationAssistance;
import jenkins.plugins.coverity.ws.DefectReader;

public class CoverityToolHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, CoverityPublisher publisher) throws Exception {
        int result;
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        CoverityTempDir temp = (CoverityTempDir)build.getAction(CoverityTempDir.class);
        Node node = Executor.currentExecutor().getOwner().getNode();
        CoverityToolInstallation installation = CoverityUtils.findToolInstallationForBuild(node, build.getEnvironment((TaskListener)listener), (TaskListener)listener);
        String home = installation != null ? installation.getHome() : null;
        CoverityUtils.checkDir(launcher.getChannel(), home);
        listener.getLogger().println("[Coverity] Tools installation '" + installation.getName() + "' with directory '" + installation.getHome() + "'");
        CIMStream cimStream = publisher.getCimStream();
        CIMInstance cim = publisher.getDescriptor().getInstance(publisher);
        boolean useAdvancedParser = false;
        InvocationAssistance invocationAssistance = publisher.getInvocationAssistance();
        if (invocationAssistance != null && invocationAssistance.getUseAdvancedParser()) {
            useAdvancedParser = true;
        }
        if (!envVars.containsKey((Object)"COV_IDIR") && temp != null) {
            envVars.put("COV_IDIR", temp.getTempDir().getRemote());
        }
        if (!envVars.containsKey((Object)"COV_ANALYSIS_ROOT")) {
            envVars.put("COV_ANALYSIS_ROOT", home);
        }
        try {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(true);
            CovBuildScriptCommand covBuildScriptCommand = new CovBuildScriptCommand(build, launcher, (TaskListener)listener, publisher, home, envVars);
            result = covBuildScriptCommand.runCommand();
            if (result != 0) {
                listener.getLogger().println("[Coverity] cov-build returned " + result + ", aborting...");
                build.setResult(Result.FAILURE);
                return;
            }
        }
        finally {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(false);
        }
        try {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(true);
            PostCovBuildCommand postCovBuildCommand = new PostCovBuildCommand(build, launcher, (TaskListener)listener, publisher, envVars);
            result = postCovBuildCommand.runCommand();
            if (result != 0) {
                listener.getLogger().println("[Coverity] post cov-build command returned " + result + ", aborting...");
                build.setResult(Result.FAILURE);
                return;
            }
        }
        finally {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(false);
        }
        try {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(true);
            CovEmitJavaCommand covEmitJavaCommand = new CovEmitJavaCommand(build, launcher, (TaskListener)listener, publisher, home, envVars, useAdvancedParser);
            result = covEmitJavaCommand.runCommand();
            if (result != 0) {
                listener.getLogger().println("[Coverity] cov-emit-java returned " + result + ", aborting...");
                build.setResult(Result.FAILURE);
                return;
            }
        }
        finally {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(false);
        }
        try {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(true);
            CovCaptureCommand covCaptureCommand = new CovCaptureCommand(build, launcher, (TaskListener)listener, publisher, home, envVars);
            result = covCaptureCommand.runCommand();
            if (result != 0) {
                listener.getLogger().println("[Coverity] cov-capture returned " + result + ", aborting...");
                build.setResult(Result.FAILURE);
                return;
            }
        }
        finally {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(false);
        }
        try {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(true);
            CovManageHistoryCommand covManageHistoryCommand = new CovManageHistoryCommand(build, launcher, (TaskListener)listener, publisher, home, envVars, cimStream, cim);
            result = covManageHistoryCommand.runCommand();
            if (result != 0) {
                listener.getLogger().println("[Coverity] cov-manage-history returned " + result + ", aborting...");
                build.setResult(Result.FAILURE);
                return;
            }
        }
        finally {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(false);
        }
        try {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(true);
            CovImportScmCommand covImportScmCommand = new CovImportScmCommand(build, launcher, (TaskListener)listener, publisher, home, envVars);
            result = covImportScmCommand.runCommand();
            if (result != 0) {
                listener.getLogger().println("[Coverity] cov-import-scm returned " + result + ", aborting...");
                build.setResult(Result.FAILURE);
                return;
            }
        }
        finally {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(false);
        }
        try {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(true);
            CovAnalyzeCommand covAnalyzeCommand = new CovAnalyzeCommand(build, launcher, (TaskListener)listener, publisher, home, envVars);
            result = covAnalyzeCommand.runCommand();
            if (result != 0) {
                listener.getLogger().println("[Coverity] cov-analyze returned " + result + ", aborting...");
                build.setResult(Result.FAILURE);
                return;
            }
        }
        finally {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(false);
        }
        try {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(true);
            PostCovAnalyzeCommand postCovAnalyzeCommand = new PostCovAnalyzeCommand(build, launcher, (TaskListener)listener, publisher, envVars);
            result = postCovAnalyzeCommand.runCommand();
            if (result != 0) {
                listener.getLogger().println("[Coverity] post cov-analyze command returned " + result + ", aborting...");
                build.setResult(Result.FAILURE);
                return;
            }
        }
        finally {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(false);
        }
        try {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(true);
            CovImportMsvscaCommand covImportMsvscaCommand = new CovImportMsvscaCommand(build, launcher, (TaskListener)listener, publisher, home, envVars, build.getWorkspace());
            result = covImportMsvscaCommand.runCommand();
            if (result != 0) {
                listener.getLogger().println("[Coverity] cov-import-msvsca returned " + result + ", aborting...");
                build.setResult(Result.FAILURE);
                return;
            }
        }
        finally {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(false);
        }
        try {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(true);
            CovCommitDefectsCommand covCommitDefectsCommand = new CovCommitDefectsCommand(build, launcher, (TaskListener)listener, publisher, home, envVars, cimStream, cim);
            result = covCommitDefectsCommand.runCommand();
            if (result != 0) {
                listener.getLogger().println("[Coverity] cov-commit-defects returned " + result + ", aborting...");
                build.setResult(Result.FAILURE);
                return;
            }
        }
        finally {
            CoverityLauncherDecorator.CoverityPostBuildAction.set(false);
        }
        if (!publisher.getSkipFetchingDefects()) {
            DefectReader defectReader = new DefectReader(build, listener, publisher);
            defectReader.getLatestDefectsForBuild();
        }
    }
}

