/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import javax.annotation.Nonnull;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTempDir;
import jenkins.plugins.coverity.CoverityTool.Command;
import jenkins.plugins.coverity.SSLConfigurations;
import jenkins.plugins.coverity.TaOptionBlock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public abstract class CoverityCommand
extends Command {
    protected static final String intermediateDirArguments = "--dir";
    private static final String covIdirEnvVar = "COV_IDIR";
    protected static final String useSslArg = "--ssl";
    private static final String onNewCertArg = "--on-new-cert";
    private static final String trustArg = "trust";
    private static final String certArg = "--certs";

    public CoverityCommand(@Nonnull String command, AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, CoverityPublisher publisher, String home, EnvVars envVars) {
        super(build, launcher, listener, publisher, envVars);
        Validate.notEmpty((String)command, (String)"Command cannot be null empty or null");
        this.addCommand(command, home);
        this.addIntermediateDir();
    }

    private void addCommand(String cmd, String home) {
        String command = cmd;
        if (!StringUtils.isEmpty((String)home)) {
            command = new FilePath(this.launcher.getChannel(), home).child("bin").child(command).getRemote();
        }
        this.commandLine.add(command);
    }

    protected void addIntermediateDir() {
        this.commandLine.add(intermediateDirArguments);
        String idir = (String)this.envVars.get((Object)covIdirEnvVar);
        if (!StringUtils.isEmpty((String)idir)) {
            this.commandLine.add(idir);
        } else {
            CoverityTempDir tempDir = (CoverityTempDir)this.build.getAction(CoverityTempDir.class);
            if (tempDir != null) {
                this.commandLine.add(tempDir.getTempDir().getRemote());
            } else {
                this.commandLine.add("$COV_IDIR");
            }
        }
    }

    protected void addTaCommandArgs() {
        if (this.publisher == null) {
            return;
        }
        TaOptionBlock taOptionBlock = this.publisher.getTaOptionBlock();
        if (taOptionBlock != null) {
            this.addArguments(taOptionBlock.getTaCommandArgs());
        }
    }

    protected void addSslConfiguration(CIMInstance cimInstance) {
        if (cimInstance.isUseSSL()) {
            boolean isTrustNewSelfSignedCert = false;
            String certFileName = null;
            SSLConfigurations sslConfigurations = this.publisher.getDescriptor().getSslConfigurations();
            if (sslConfigurations != null) {
                isTrustNewSelfSignedCert = sslConfigurations.isTrustNewSelfSignedCert();
                certFileName = sslConfigurations.getCertFileName();
                if (isTrustNewSelfSignedCert) {
                    this.addArgument(onNewCertArg);
                    this.addArgument(trustArg);
                }
                if (certFileName != null) {
                    this.addArgument(certArg);
                    this.addArgument(certFileName);
                }
            }
        }
    }
}

