/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import com.coverity.ws.v9.SnapshotFilterSpecDataObj;
import com.coverity.ws.v9.SnapshotIdDataObj;
import com.coverity.ws.v9.StreamIdDataObj;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.util.List;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CIMStream;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTool.CoverityCommand;
import jenkins.plugins.coverity.CoverityUtils;
import jenkins.plugins.coverity.TaOptionBlock;

public class CovManageHistoryCommand
extends CoverityCommand {
    private static final String command = "cov-manage-history";
    private static final String downloadArg = "download";
    private static final String hostArg = "--host";
    private static final String portArg = "--port";
    private static final String streamArg = "--stream";
    private static final String userArg = "--user";
    private static final String mergeArg = "--merge";
    private static final String coverity_passphrase = "COVERITY_PASSPHRASE";
    private CIMInstance cimInstance;
    private CIMStream cimStream;

    public CovManageHistoryCommand(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, CoverityPublisher publisher, String home, EnvVars envVars, CIMStream cimStream, CIMInstance cimInstance) {
        super(command, build, launcher, listener, publisher, home, envVars);
        this.cimStream = cimStream;
        this.cimInstance = cimInstance;
    }

    @Override
    protected void prepareCommand() {
        this.addArgument(downloadArg);
        this.addCimStreamInfo();
        if (this.cimInstance.isUseSSL()) {
            this.addArgument("--ssl");
        }
        this.addSslConfiguration(this.cimInstance);
        this.addUserInfo();
        this.addArgument(mergeArg);
        this.listener.getLogger().println("[Coverity] cov-manage-history command line arguments: " + this.commandLine.toString());
    }

    @Override
    protected boolean canExecute() {
        TaOptionBlock taOptionBlock = this.publisher.getTaOptionBlock();
        if (taOptionBlock == null || !taOptionBlock.getCovHistoryCheckbox()) {
            return false;
        }
        return this.checkSnapshot();
    }

    private void addCimStreamInfo() {
        this.addArgument(hostArg);
        this.addArgument(this.cimInstance.getHost());
        this.addArgument(portArg);
        this.addArgument(Integer.toString(this.cimInstance.getPort()));
        this.addArgument(streamArg);
        this.addArgument(CoverityUtils.doubleQuote(this.cimStream.getStream(), this.publisher.getInvocationAssistance().getUseAdvancedParser()));
    }

    private void addUserInfo() {
        this.addArgument(userArg);
        this.addArgument(this.cimInstance.getCoverityUser());
        this.envVars.put(coverity_passphrase, this.cimInstance.getCoverityPassword());
    }

    private boolean checkSnapshot() {
        StreamIdDataObj streamId = new StreamIdDataObj();
        streamId.setName(this.cimStream.getStream());
        SnapshotFilterSpecDataObj filter = new SnapshotFilterSpecDataObj();
        try {
            List<SnapshotIdDataObj> snapshotList = this.cimInstance.getConfigurationService().getSnapshotsForStream(streamId, filter);
            return snapshotList != null && !snapshotList.isEmpty();
        }
        catch (Exception e) {
            this.launcher.getListener().getLogger().println("Error occurred while checking the stream \"" + this.cimStream.getStream() + "\" has any snapshots");
            return false;
        }
    }
}

