/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTool.CoverityCommand;
import jenkins.plugins.coverity.CoverityUtils;
import jenkins.plugins.coverity.EnvParser;
import jenkins.plugins.coverity.ParseException;
import jenkins.plugins.coverity.ScmOptionBlock;
import org.apache.commons.lang.StringUtils;

public class CovImportScmCommand
extends CoverityCommand {
    private static final String command = "cov-import-scm";
    private static final String scmFlag = "--scm";
    private static final String toolFlag = "--tool";
    private static final String toolArgsFlag = "--tool-arg";
    private static final String commandArgFlag = "--command-arg";
    private static final String scmLog = "--log";
    private static final String scmFileRegex = "--filename-regex";
    private static final String projectRootFlag = "--project-root";
    private static final String noScmTool = "none";
    private ScmOptionBlock scmOptionBlock;
    private boolean useAdvancedParser;

    public CovImportScmCommand(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, CoverityPublisher publisher, String home, EnvVars envVars) {
        super(command, build, launcher, listener, publisher, home, envVars);
        this.scmOptionBlock = publisher.getScmOptionBlock();
        if (publisher.getInvocationAssistance() != null) {
            this.useAdvancedParser = publisher.getInvocationAssistance().getUseAdvancedParser();
        }
    }

    @Override
    protected void prepareCommand() {
        this.addScmTool();
        this.addScmToolArguments();
        this.addScmCommandArguments();
        this.addLogFileLocation();
        this.addFileRegex();
        if (this.scmOptionBlock.getScmSystem().equalsIgnoreCase("accurev")) {
            this.addAccurevProjectRoot();
        } else if (this.scmOptionBlock.getScmSystem().equalsIgnoreCase("perforce") || this.scmOptionBlock.getScmSystem().equalsIgnoreCase("perforce2009")) {
            this.addP4port();
        }
        this.addScmAdditionalCommand();
        this.listener.getLogger().println("[Coverity] cov-import-scm command line arguments: " + this.commandLine.toString());
    }

    @Override
    protected boolean canExecute() {
        return this.scmOptionBlock != null && !this.scmOptionBlock.getScmSystem().equalsIgnoreCase(noScmTool);
    }

    private void addScmTool() {
        this.addArgument(scmFlag);
        this.addArgument(this.scmOptionBlock.getScmSystem());
        if (this.scmOptionBlock.getCustomTestTool() != null) {
            this.addArgument(toolFlag);
            this.addArgument(this.scmOptionBlock.getCustomTestTool());
        }
    }

    private void addScmToolArguments() {
        if (this.scmOptionBlock.getScmToolArguments() != null) {
            this.addArgument(toolArgsFlag);
            this.addArgument(CoverityUtils.doubleQuote(this.scmOptionBlock.getScmToolArguments(), this.useAdvancedParser));
        }
    }

    private void addScmCommandArguments() {
        if (this.scmOptionBlock.getScmCommandArgs() != null) {
            this.addArgument(commandArgFlag);
            this.addArgument(CoverityUtils.doubleQuote(this.scmOptionBlock.getScmCommandArgs(), this.useAdvancedParser));
        }
    }

    private void addLogFileLocation() {
        if (this.scmOptionBlock.getLogFileLoc() != null) {
            this.addArgument(scmLog);
            this.addArgument(this.scmOptionBlock.getLogFileLoc());
        }
    }

    private void addFileRegex() {
        if (this.scmOptionBlock.getFileRegex() != null) {
            this.addArgument(scmFileRegex);
            this.addArgument(this.scmOptionBlock.getFileRegex());
        }
    }

    private void addAccurevProjectRoot() {
        if (this.scmOptionBlock.getAccRevRepo() != null) {
            this.addArgument(projectRootFlag);
            this.addArgument(this.scmOptionBlock.getAccRevRepo());
        }
    }

    private void addP4port() {
        if (!StringUtils.isEmpty((String)this.scmOptionBlock.getP4Port())) {
            this.envVars.put("P4PORT", CoverityUtils.evaluateEnvVars(this.scmOptionBlock.getP4Port(), this.envVars, this.useAdvancedParser));
        }
    }

    private void addScmAdditionalCommand() {
        try {
            if (this.scmOptionBlock.getScmAdditionalCmd() != null) {
                this.addArguments(EnvParser.tokenize(this.scmOptionBlock.getScmAdditionalCmd()));
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("ParseException occurred during tokenizing the cov import scm additional command.");
        }
    }
}

