/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTool.CoverityCommand;
import jenkins.plugins.coverity.CoverityUtils;
import jenkins.plugins.coverity.InvocationAssistance;

public class CovImportMsvscaCommand
extends CoverityCommand {
    private static final String command = "cov-import-msvsca";
    private static final String appendFlag = "--append";
    private File[] outputFiles;
    private FilePath workSpace;

    public CovImportMsvscaCommand(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, CoverityPublisher publisher, String home, EnvVars envVars, FilePath workspace) {
        super(command, build, launcher, listener, publisher, home, envVars);
        this.workSpace = workspace;
    }

    @Override
    protected void prepareCommand() {
        this.addOutputFiles();
        this.listener.getLogger().println("[Coverity] cov-import-msvsca command line arguments: " + this.commandLine.toString());
    }

    @Override
    protected boolean canExecute() {
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        if (invocationAssistance == null || !invocationAssistance.getCsharpMsvsca()) {
            return false;
        }
        this.outputFiles = this.findMsvscaOutputFiles(this.workSpace.getRemote());
        if (this.outputFiles == null || this.outputFiles.length == 0) {
            this.listener.getLogger().println("[Coverity] MSVSCA No results found, skipping");
            return false;
        }
        return true;
    }

    private void addOutputFiles() {
        this.addArgument(appendFlag);
        for (File outputFile : this.outputFiles) {
            this.addArgument(outputFile.getAbsolutePath());
        }
    }

    private File[] findMsvscaOutputFiles(String dirName) {
        this.listener.getLogger().println("[Coverity] Searching for Microsoft Code Analysis results...");
        File dir = new File(dirName);
        Collection<File> files = CoverityUtils.listFiles(dir, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith("CodeAnalysisLog.xml");
            }
        }, true);
        return files.toArray(new File[files.size()]);
    }
}

