/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTool.CoverityCommand;
import jenkins.plugins.coverity.CoverityUtils;
import jenkins.plugins.coverity.InvocationAssistance;

public class CovEmitJavaCommand
extends CoverityCommand {
    private static final String command = "cov-emit-java";
    private static final String webAppArchive = "--webapp-archive";
    private EnvVars envVars;
    private boolean useAdvancedParser;

    public CovEmitJavaCommand(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, CoverityPublisher publisher, String home, EnvVars envVars, boolean useAdvancedParser) {
        super(command, build, launcher, listener, publisher, home, envVars);
        this.envVars = envVars;
        this.useAdvancedParser = useAdvancedParser;
    }

    @Override
    protected void prepareCommand() {
        this.addJavaWarFiles();
        this.listener.getLogger().println("[Coverity] cov-emit-java command line arguments: " + this.commandLine.toString());
    }

    @Override
    protected boolean canExecute() {
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        if (invocationAssistance == null) {
            return false;
        }
        List<String> givenWarFiles = invocationAssistance.getJavaWarFilesNames();
        return givenWarFiles != null && !givenWarFiles.isEmpty();
    }

    private void addJavaWarFiles() {
        ArrayList<String> javaWarFiles = new ArrayList<String>();
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        List<String> givenWarFiles = invocationAssistance.getJavaWarFilesNames();
        if (givenWarFiles != null && !givenWarFiles.isEmpty()) {
            for (String givenJar : givenWarFiles) {
                String javaWarFile = CoverityUtils.evaluateEnvVars(givenJar, this.envVars, this.useAdvancedParser);
                if (javaWarFile == null) continue;
                javaWarFiles.add(javaWarFile);
            }
        }
        if (javaWarFiles != null && !javaWarFiles.isEmpty()) {
            for (String javaWarFile : javaWarFiles) {
                this.addArgument(webAppArchive);
                this.addArgument(javaWarFile);
            }
        }
    }
}

