/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CIMStream;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTool.CoverityCommand;
import jenkins.plugins.coverity.CoverityUtils;
import jenkins.plugins.coverity.EnvParser;
import jenkins.plugins.coverity.InvocationAssistance;
import jenkins.plugins.coverity.ParseException;
import org.apache.commons.lang.StringUtils;

public class CovCommitDefectsCommand
extends CoverityCommand {
    private static final String command = "cov-commit-defects";
    private static final String hostArg = "--host";
    private static final String dataPort = "--dataport";
    private static final String httpsPort = "--https-port";
    private static final String port = "--port";
    private static final String streamArg = "--stream";
    private static final String userArg = "--user";
    private static final String coverity_passphrase = "COVERITY_PASSPHRASE";
    private CIMInstance cimInstance;
    private CIMStream cimStream;
    private InvocationAssistance invocationAssistance;

    public CovCommitDefectsCommand(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, CoverityPublisher publisher, String home, EnvVars envVars, CIMStream cimStream, CIMInstance cimInstance) {
        super(command, build, launcher, listener, publisher, home, envVars);
        this.cimStream = cimStream;
        this.cimInstance = cimInstance;
        if (publisher != null && publisher.getInvocationAssistance() != null) {
            this.invocationAssistance = publisher.getInvocationAssistance();
        }
    }

    @Override
    protected void prepareCommand() {
        this.addHost();
        if (this.cimInstance.isUseSSL()) {
            this.addSsl();
            this.addHtppsPort();
            this.addSslConfiguration(this.cimInstance);
        } else {
            this.addPort();
        }
        this.addStream();
        this.addUserInfo();
        this.addCommitArguments();
        this.listener.getLogger().println("[Coverity] cov-commit-defects command line arguments: " + this.commandLine.toString());
    }

    @Override
    protected boolean canExecute() {
        return this.publisher.getInvocationAssistance() != null;
    }

    private void addHost() {
        this.addArgument(hostArg);
        this.addArgument(this.cimInstance.getHost());
    }

    private void addHtppsPort() {
        this.addArgument(httpsPort);
        this.addArgument(Integer.toString(this.cimInstance.getPort()));
    }

    private void addPort() {
        this.addArgument(port);
        this.addArgument(Integer.toString(this.cimInstance.getPort()));
    }

    private void addStream() {
        this.addArgument(streamArg);
        this.addArgument(CoverityUtils.doubleQuote(this.cimStream.getStream(), this.invocationAssistance.getUseAdvancedParser()));
    }

    private void addUserInfo() {
        this.addArgument(userArg);
        this.addArgument(this.cimInstance.getCoverityUser());
        this.envVars.put(coverity_passphrase, this.cimInstance.getCoverityPassword());
    }

    private void addCommitArguments() {
        if (!StringUtils.isEmpty((String)this.invocationAssistance.getCommitArguments())) {
            try {
                this.addArguments(EnvParser.tokenize(this.invocationAssistance.getCommitArguments()));
            }
            catch (ParseException e) {
                throw new RuntimeException("ParseException occurred during tokenizing the cov-commit-defect commit arguments.");
            }
        }
    }

    private void addSsl() {
        if (this.cimInstance.isUseSSL()) {
            this.addArgument("--ssl");
        }
    }
}

