/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTool.CoverityCommand;
import jenkins.plugins.coverity.EnvParser;
import jenkins.plugins.coverity.ParseException;
import jenkins.plugins.coverity.TaOptionBlock;
import org.apache.commons.lang.StringUtils;

public class CovCaptureCommand
extends CoverityCommand {
    private static final String command = "cov-capture";

    public CovCaptureCommand(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, CoverityPublisher publisher, String home, EnvVars envVars) {
        super(command, build, launcher, listener, publisher, home, envVars);
    }

    @Override
    protected void prepareCommand() {
        this.addTaCommandArgs();
        this.addCustomTestCommand();
        this.listener.getLogger().println("[Coverity] cov-capture command line arguments: " + this.commandLine.toString());
    }

    @Override
    protected boolean canExecute() {
        if (this.publisher.getTaOptionBlock() == null) {
            return false;
        }
        return !StringUtils.isEmpty((String)this.publisher.getTaOptionBlock().getCustomTestCommand());
    }

    private void addCustomTestCommand() {
        TaOptionBlock taOptionBlock = this.publisher.getTaOptionBlock();
        try {
            if (!StringUtils.isEmpty((String)taOptionBlock.getCustomTestCommand())) {
                this.addArguments(EnvParser.tokenize(taOptionBlock.getCustomTestCommand()));
            }
        }
        catch (ParseException parseException) {
            throw new RuntimeException("ParseException occurred during tokenizing the cov capture custom test command.");
        }
    }
}

