/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTool.CoverityCommand;
import jenkins.plugins.coverity.EnvParser;
import jenkins.plugins.coverity.InvocationAssistance;
import org.apache.commons.lang.StringUtils;

public class CovBuildScriptCommand
extends CoverityCommand {
    private static final String command = "cov-build";
    private static final String noCommandArg = "--no-command";
    private static final String fileSystemCapture = "--fs-capture-search";

    public CovBuildScriptCommand(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, CoverityPublisher publisher, String home, EnvVars envVars) {
        super(command, build, launcher, listener, publisher, home, envVars);
    }

    @Override
    protected void prepareCommand() {
        this.addArgument(noCommandArg);
        this.addScriptSourcesArgs();
        this.addAdditionalBuildArguments();
        this.listener.getLogger().println("[Coverity] cov-build command line arguments for script sources: " + this.commandLine.toString());
    }

    @Override
    protected boolean canExecute() {
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        return invocationAssistance != null && invocationAssistance.getIsScriptSrc();
    }

    private void addScriptSourcesArgs() {
        this.addArgument(fileSystemCapture);
        this.addArgument("$WORKSPACE");
    }

    private void addAdditionalBuildArguments() {
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        String buildArgs = invocationAssistance.getBuildArguments();
        if (!StringUtils.isEmpty((String)buildArgs)) {
            this.addArguments(EnvParser.tokenizeWithRuntimeException(buildArgs));
        }
    }
}

