/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.util.List;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTool.CoverityCommand;
import jenkins.plugins.coverity.EnvParser;
import jenkins.plugins.coverity.InvocationAssistance;
import org.apache.commons.lang.StringUtils;

public class CovBuildCompileCommand
extends CoverityCommand {
    private static final String command = "cov-build";

    public CovBuildCompileCommand(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, CoverityPublisher publisher, String home, EnvVars envVars) {
        super(command, build, launcher, listener, publisher, home, envVars);
    }

    @Override
    protected void prepareCommand() {
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        if (invocationAssistance != null) {
            this.addTaCommandArgs();
            this.addAdditionalBuildArguments();
        }
        this.listener.getLogger().println("[Coverity] cov-build command line arguments for compiled sources: " + this.commandLine.toString());
    }

    @Override
    protected boolean canExecute() {
        return true;
    }

    @Override
    protected void addIntermediateDir() {
        this.commandLine.add("--dir");
        this.commandLine.add("$COV_IDIR");
    }

    private void addAdditionalBuildArguments() {
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        String buildArgs = invocationAssistance.getBuildArguments();
        if (!StringUtils.isEmpty((String)buildArgs)) {
            this.addArguments(EnvParser.tokenizeWithRuntimeException(buildArgs));
        }
    }

    public List<String> constructArguments() {
        this.prepareCommand();
        return this.commandLine;
    }
}

