/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.util.List;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTool.CoverityCommand;
import jenkins.plugins.coverity.EnvParser;
import jenkins.plugins.coverity.InvocationAssistance;
import jenkins.plugins.coverity.ParseException;
import jenkins.plugins.coverity.TaOptionBlock;
import jenkins.plugins.coverity.TaStripPath;
import org.apache.commons.lang.StringUtils;

public class CovAnalyzeCommand
extends CoverityCommand {
    private static final String command = "cov-analyze";
    private static final String misraConfig = "--misra-config";
    private static final String testAdvisor = "--test-advisor";
    private static final String testAdvisorPolicyFile = "--test-advisor-policy";
    private static final String stripPath = "--strip-path";

    public CovAnalyzeCommand(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, CoverityPublisher publisher, String home, EnvVars envVars) {
        super(command, build, launcher, listener, publisher, home, envVars);
    }

    @Override
    protected void prepareCommand() {
        this.addMisraConfiguration();
        this.addTaConfiguration();
        this.addAdditionalAnalysisArguments();
        this.listener.getLogger().println("[Coverity] cov-analyze command line arguments: " + this.commandLine.toString());
    }

    @Override
    protected boolean canExecute() {
        return this.publisher.getInvocationAssistance() != null || this.publisher.getTaOptionBlock() != null;
    }

    private void addMisraConfiguration() {
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        if (invocationAssistance != null && invocationAssistance.getIsUsingMisra()) {
            String misraConfigFile = invocationAssistance.getMisraConfigFile();
            if (!StringUtils.isEmpty((String)misraConfigFile)) {
                this.addArgument(misraConfig);
                this.addArgument(misraConfigFile);
            } else {
                throw new RuntimeException("Misra configuration file is required to run Misra analysis.");
            }
        }
    }

    private void addTaConfiguration() {
        TaOptionBlock taOptionBlock = this.publisher.getTaOptionBlock();
        if (taOptionBlock != null) {
            String taPolicyFile = taOptionBlock.getPolicyFile();
            if (!StringUtils.isEmpty((String)taPolicyFile)) {
                this.addArgument(testAdvisor);
                this.addArgument(testAdvisorPolicyFile);
                this.addArgument(taPolicyFile);
                List<TaStripPath> taStripPaths = taOptionBlock.getTaStripPaths();
                if (taStripPaths == null || taStripPaths.isEmpty()) {
                    this.addArgument(stripPath);
                    this.addArgument(this.build.getWorkspace().getRemote());
                } else {
                    for (TaStripPath path : taStripPaths) {
                        this.addArgument(stripPath);
                        this.addArgument(path.getTaStripPath());
                    }
                }
            } else {
                throw new RuntimeException("Test Advisor Policy File is required to run the Test Advisor.");
            }
        }
    }

    private void addAdditionalAnalysisArguments() {
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        try {
            String additionalArgument;
            if (invocationAssistance != null && !StringUtils.isEmpty((String)(additionalArgument = invocationAssistance.getAnalyzeArguments()))) {
                this.addArguments(EnvParser.tokenize(additionalArgument));
            }
        }
        catch (ParseException parseException) {
            throw new RuntimeException("ParseException occurred during tokenizing the cov analyze additional arguments.");
        }
    }
}

