/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity.CoverityTool;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityUtils;
import jenkins.plugins.coverity.InvocationAssistance;
import org.apache.commons.lang.Validate;

public abstract class Command {
    protected List<String> commandLine;
    protected AbstractBuild build;
    protected Launcher launcher;
    protected TaskListener listener;
    protected CoverityPublisher publisher;
    protected EnvVars envVars;

    public Command(@Nonnull AbstractBuild<?, ?> build, @Nonnull Launcher launcher, @Nonnull TaskListener listener, @Nonnull CoverityPublisher publisher, @Nonnull EnvVars envVars) {
        Validate.notNull(build, (String)(AbstractBuild.class.getName() + " object cannot be null"));
        Validate.notNull((Object)launcher, (String)(Launcher.class.getName() + " object cannot be null"));
        Validate.notNull((Object)listener, (String)(TaskListener.class.getName() + " object cannot be null"));
        Validate.notNull((Object)((Object)publisher), (String)(CoverityPublisher.class.getName() + " object cannot be null"));
        Validate.notNull((Object)envVars, (String)(EnvVars.class.getName() + " object cannot be null"));
        this.build = build;
        this.launcher = launcher;
        this.listener = listener;
        this.publisher = publisher;
        this.envVars = envVars;
        this.commandLine = new ArrayList<String>();
    }

    protected void addArgument(String args) {
        this.commandLine.add(args);
    }

    protected void addArguments(List<String> args) {
        this.commandLine.addAll(args);
    }

    public int runCommand() throws IOException, InterruptedException {
        boolean useAdvancedParser = false;
        InvocationAssistance invocationAssistance = this.publisher.getInvocationAssistance();
        if (invocationAssistance != null && invocationAssistance.getUseAdvancedParser()) {
            useAdvancedParser = true;
        }
        if (this.canExecute()) {
            this.prepareCommand();
            return CoverityUtils.runCmd(this.commandLine, this.build, this.launcher, this.listener, this.envVars, useAdvancedParser);
        }
        return 0;
    }

    protected abstract void prepareCommand();

    protected abstract boolean canExecute();
}

