/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Environment;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.plugins.coverity.CheckConfig;
import jenkins.plugins.coverity.CoverityPublisher;

@Extension
public class CoverityRunListener
extends RunListener<Run> {
    public void onCompleted(Run run, @Nonnull TaskListener listener) {
        super.onCompleted(run, listener);
    }

    public void onFinalized(Run run) {
        super.onFinalized(run);
    }

    public void onStarted(Run run, TaskListener listener) {
        super.onStarted(run, listener);
    }

    public Environment setUpEnvironment(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        AbstractProject project = build.getProject();
        CoverityPublisher publisher = (CoverityPublisher)project.getPublishersList().get(CoverityPublisher.class);
        if (publisher == null || publisher.getInvocationAssistance() == null) {
            return super.setUpEnvironment(build, launcher, listener);
        }
        listener.getLogger().println("\nChecking Coverity configuration...");
        CheckConfig cc = new CheckConfig(publisher, build, launcher, listener);
        cc.check();
        for (CheckConfig.Status s : cc.getStatus()) {
            listener.getLogger().println(s.getStatus());
        }
        if (cc.isValid()) {
            listener.getLogger().println("Configuration is valid.\n");
            return super.setUpEnvironment(build, launcher, listener);
        }
        listener.getLogger().println("Configuration is invalid. Aborting build.\n");
        throw new Run.RunnerAbortedException();
    }

    public void onDeleted(Run run) {
        super.onDeleted(run);
    }
}

