/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.coverity.ws.v9.CovRemoteServiceException_Exception;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.xml.ws.WebServiceException;
import jenkins.model.Jenkins;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CIMStream;
import jenkins.plugins.coverity.CheckConfig;
import jenkins.plugins.coverity.CoverityTempDir;
import jenkins.plugins.coverity.CoverityTool.CoverityToolHandler;
import jenkins.plugins.coverity.CoverityToolInstallation;
import jenkins.plugins.coverity.CoverityUtils;
import jenkins.plugins.coverity.CoverityVersion;
import jenkins.plugins.coverity.DefectFilters;
import jenkins.plugins.coverity.InvocationAssistance;
import jenkins.plugins.coverity.SSLConfigurations;
import jenkins.plugins.coverity.ScmOptionBlock;
import jenkins.plugins.coverity.TaOptionBlock;
import jenkins.plugins.coverity.ws.CimCache;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class CoverityPublisher
extends Recorder {
    private static final Logger logger = Logger.getLogger(CoverityPublisher.class.getName());
    private transient String cimInstance;
    private transient String project;
    private transient String stream;
    private transient DefectFilters defectFilters;
    private transient List<CIMStream> cimStreams;
    private CIMStream cimStream;
    private InvocationAssistance invocationAssistance;
    private boolean failBuild;
    private boolean unstable;
    private boolean keepIntDir;
    private boolean skipFetchingDefects;
    private boolean hideChart;
    private TaOptionBlock taOptionBlock;
    private ScmOptionBlock scmOptionBlock;
    private boolean unstableBuild;

    @DataBoundConstructor
    public CoverityPublisher(CIMStream cimStream) {
        this.cimStream = cimStream;
        this.unstableBuild = false;
    }

    protected Object readResolve() {
        if (this.cimInstance != null || this.project != null || this.stream != null || this.defectFilters != null) {
            logger.info("Old data format detected. Converting to new format.");
            this.convertTransientDataFields();
            return this;
        }
        if (this.cimStreams != null && !this.cimStreams.isEmpty()) {
            logger.info("Old data format detected. Converting to new format.");
            if (this.cimStreams.size() > 1) {
                logger.info("Found multiple commit streams configured. Discarding all but the first stream configured");
            }
            this.cimStream = this.cimStreams.get(0);
            this.cimStreams = null;
            if (this.cimStream.getInvocationAssistanceOverride() != null) {
                this.invocationAssistance = this.getInvocationAssistance().merge(this.cimStream.getInvocationAssistanceOverride());
            }
        }
        return this;
    }

    private void convertTransientDataFields() {
        CIMStream newcs = new CIMStream(this.cimInstance, this.project, this.stream);
        newcs.setDefectFilters(this.defectFilters);
        this.cimInstance = null;
        this.project = null;
        this.stream = null;
        this.defectFilters = null;
        if (this.cimStream == null) {
            this.cimStream = newcs;
        }
    }

    public CIMStream getCimStream() {
        return this.cimStream;
    }

    public String getCimInstance() {
        return this.cimInstance;
    }

    public String getProject() {
        return this.project;
    }

    public String getStream() {
        return this.stream;
    }

    public DefectFilters getDefectFilters() {
        return this.defectFilters;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    @DataBoundSetter
    public void setInvocationAssistance(InvocationAssistance invocationAssistance) {
        this.invocationAssistance = invocationAssistance;
    }

    public InvocationAssistance getInvocationAssistance() {
        return this.invocationAssistance;
    }

    @DataBoundSetter
    public void setFailBuild(boolean failBuild) {
        this.failBuild = failBuild;
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    @DataBoundSetter
    public void setKeepIntDir(boolean keepIntDir) {
        this.keepIntDir = keepIntDir;
    }

    public boolean getKeepIntDir() {
        return this.keepIntDir;
    }

    @DataBoundSetter
    public void setSkipFetchingDefects(boolean skipFetchingDefects) {
        this.skipFetchingDefects = skipFetchingDefects;
    }

    public boolean getSkipFetchingDefects() {
        return this.skipFetchingDefects;
    }

    @DataBoundSetter
    public void setHideChart(boolean hideChart) {
        this.hideChart = hideChart;
    }

    public boolean getHideChart() {
        return this.hideChart;
    }

    @DataBoundSetter
    public void setUnstable(boolean unstable) {
        this.unstable = unstable;
    }

    public boolean isUnstable() {
        return this.unstable;
    }

    public boolean isUnstableBuild() {
        return this.unstableBuild;
    }

    public void setUnstableBuild(boolean unstable) {
        this.unstableBuild = unstable;
    }

    @DataBoundSetter
    public void setTaOptionBlock(TaOptionBlock taOptionBlock) {
        this.taOptionBlock = taOptionBlock;
    }

    public TaOptionBlock getTaOptionBlock() {
        return this.taOptionBlock;
    }

    @DataBoundSetter
    public void setScmOptionBlock(ScmOptionBlock scmOptionBlock) {
        this.scmOptionBlock = scmOptionBlock;
    }

    public ScmOptionBlock getScmOptionBlock() {
        return this.scmOptionBlock;
    }

    public List<CIMStream> getCimStreams() {
        if (this.cimStreams == null) {
            return new ArrayList<CIMStream>();
        }
        return this.cimStreams;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        this.unstableBuild = false;
        if (build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return true;
        }
        try {
            CoverityVersion version = CheckConfig.checkNode(this, build, launcher, (TaskListener)listener).getVersion();
            if (version == null) {
                throw new Exception("Coverity Version is null. Please verify the version file under your Coverity Analysis installation.");
            }
            CoverityToolHandler cth = new CoverityToolHandler();
            cth.perform(build, launcher, listener, this);
            if (this.isUnstableBuild()) {
                build.setResult(Result.UNSTABLE);
            }
            this.deleteIntermediateDirectory(listener, (CoverityTempDir)build.getAction(CoverityTempDir.class));
            return true;
        }
        catch (CovRemoteServiceException_Exception e) {
            CoverityUtils.handleException("Cov Remote Service Error: \n" + e.getMessage(), build, listener, (Exception)e);
            return false;
        }
        catch (Exception e) {
            CoverityUtils.handleException("Exception message: \n" + e.getMessage(), build, listener, e);
            return false;
        }
    }

    public void deleteIntermediateDirectory(BuildListener listener, CoverityTempDir temp) {
        if (temp != null) {
            try {
                if (!this.getKeepIntDir() || temp.isDef()) {
                    listener.getLogger().println("[Coverity] deleting intermediate directory: " + temp.getTempDir());
                    temp.getTempDir().deleteRecursive();
                    listener.getLogger().println("[Coverity] deleting intermediate directory  \"" + temp.getTempDir() + "\" was successful");
                } else {
                    listener.getLogger().println("[Coverity] preserving intermediate directory: " + temp.getTempDir());
                }
            }
            catch (InterruptedException e) {
                listener.getLogger().println("[Coverity] Interrupted Exception occurred during deletion of intermediate directory: " + temp.getTempDir());
            }
            catch (IOException e) {
                listener.getLogger().println("[Coverity] IOException Exception occurred during deletion of intermediate directory: " + temp.getTempDir());
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @Deprecated
        private String home;
        private List<CIMInstance> instances = new ArrayList<CIMInstance>();
        private SSLConfigurations sslConfigurations;
        private CoverityToolInstallation[] installations = new CoverityToolInstallation[0];

        public DescriptorImpl() {
            super(CoverityPublisher.class);
            this.load();
        }

        protected Object readResolve() {
            if (StringUtils.isNotEmpty((String)this.home)) {
                boolean defaultExists = false;
                if (this.installations.length > 0) {
                    for (CoverityToolInstallation installation : this.installations) {
                        if (!"default".equalsIgnoreCase(installation.getName()) && !this.home.equals(installation.getHome())) continue;
                        defaultExists = true;
                    }
                }
                if (!defaultExists) {
                    ArrayList<CoverityToolInstallation> installationList = new ArrayList<CoverityToolInstallation>(Arrays.asList(this.installations));
                    installationList.add(new CoverityToolInstallation("default", this.home));
                    this.installations = installationList.toArray(new CoverityToolInstallation[installationList.size()]);
                }
            }
            return this;
        }

        public CIMStream.DescriptorImpl getCIMStreamDescriptor() {
            return (CIMStream.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(CIMStream.DescriptorImpl.class);
        }

        public static List<String> toStrings(ListBoxModel list) {
            ArrayList<String> result = new ArrayList<String>();
            for (ListBoxModel.Option option : list) {
                result.add(option.name);
            }
            return result;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json);
            this.home = Util.fixEmpty((String)this.home);
            this.save();
            return true;
        }

        @Deprecated
        public String getHome() {
            return this.home;
        }

        @Deprecated
        public void setHome(String home) {
            this.home = home;
        }

        public void setSslConfigurations(SSLConfigurations sslConfigurations) {
            this.sslConfigurations = sslConfigurations;
        }

        public SSLConfigurations getSslConfigurations() {
            if (this.sslConfigurations != null) {
                return this.sslConfigurations;
            }
            return new SSLConfigurations(false, null);
        }

        public List<CIMInstance> getInstances() {
            return this.instances;
        }

        public void setInstances(List<CIMInstance> instances) {
            this.instances = instances;
        }

        public CIMInstance getInstance(String name) {
            for (CIMInstance instance : this.instances) {
                if (!instance.getName().equals(name)) continue;
                return instance;
            }
            return null;
        }

        public CIMInstance getInstance(CoverityPublisher publisher) {
            CIMStream stream = publisher.getCimStream();
            if (stream != null) {
                CIMInstance instance = this.getInstance(stream.getInstance());
                if (instance != null && StringUtils.isNotEmpty((String)stream.getCredentialId())) {
                    return instance.cloneWithCredential(stream.getCredentialId());
                }
                return instance;
            }
            return null;
        }

        public CoverityToolInstallation[] getInstallations() {
            return Arrays.copyOf(this.installations, this.installations.length);
        }

        public void setInstallations(CoverityToolInstallation ... installations) {
            this.installations = installations;
            this.save();
        }

        public String getDisplayName() {
            return "Coverity";
        }

        public FormValidation doCheckInstance(@QueryParameter String host, @QueryParameter int port, @QueryParameter String user, @QueryParameter String password, @QueryParameter boolean useSSL, @QueryParameter String credentialId) {
            CIMInstance instance = new CIMInstance("", host, port, credentialId);
            instance.setUser(user);
            instance.setPassword(password);
            instance.setUseSSL(useSSL);
            return instance.doCheck();
        }

        public FormValidation doCheckHome(@QueryParameter String home) {
            if (StringUtils.isNotEmpty((String)home)) {
                return FormValidation.warning((String)"Static Analysis Location is deprecated in Coverity plugin version 1.10 and later. Please use the Coverity Static Analysis Tools global configuration instead.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCutOffDate(@QueryParameter String value) throws Descriptor.FormException {
            try {
                if (!StringUtils.isEmpty((String)value)) {
                    new SimpleDateFormat("yyyy-MM-dd").parse(value);
                }
                return FormValidation.ok();
            }
            catch (ParseException e) {
                return FormValidation.error((String)"yyyy-MM-dd expected");
            }
        }

        public FormValidation doCheckDate(@QueryParameter String date) {
            try {
                if (!StringUtils.isEmpty((String)date.trim())) {
                    new SimpleDateFormat("yyyy-MM-dd").parse(date);
                }
                return FormValidation.ok();
            }
            catch (ParseException e) {
                return FormValidation.error((String)"Date in yyyy-mm-dd format expected");
            }
        }

        public Publisher newInstance(@CheckForNull StaplerRequest req, @Nonnull JSONObject formData) throws Descriptor.FormException {
            logger.info(formData.toString());
            if (req == null) {
                return (Publisher)super.newInstance(req, formData);
            }
            String cutOffDate = Util.fixEmpty((String)req.getParameter("cutOffDate"));
            try {
                if (cutOffDate != null) {
                    new SimpleDateFormat("yyyy-MM-dd").parse(cutOffDate);
                }
            }
            catch (ParseException e) {
                throw new Descriptor.FormException("Could not parse date '" + cutOffDate + "', yyyy-MM-dd expected", "cutOffDate");
            }
            CoverityPublisher publisher = (CoverityPublisher)super.newInstance(req, formData);
            CIMStream cimStream = publisher.getCimStream();
            CIMStream.DescriptorImpl cimStreamDescriptor = (CIMStream.DescriptorImpl)cimStream.getDescriptor();
            String cimInstance = cimStream.getInstance();
            try {
                DefectFilters defectFilters;
                if (cimStream.isValid() && (defectFilters = cimStream.getDefectFilters()) != null) {
                    CIMInstance instance = this.getInstance(publisher);
                    Object allCheckers = instance != null ? instance.getCimInstanceCheckers() : new ArrayList();
                    List<String> allComponents = DescriptorImpl.toStrings(cimStreamDescriptor.doFillComponentDefectFilterItems(cimInstance, cimStream.getStream()));
                    defectFilters.invertCheckers((List<String>)allCheckers);
                    defectFilters.invertComponents(allComponents);
                }
            }
            catch (CovRemoteServiceException_Exception | WebServiceException e) {
                throw new Descriptor.FormException("There was an exception from the configured Coverity Connect server (instance: " + cimInstance + "). Please verify the Coverity Connect instance configuration is valid.", e, "defectFilters");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return publisher;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private JSONObject getJSONClassObject(JSONObject o, String targetClass) {
            JSONObject jsonA = o.getJSONObject(this.getJsonSafeClassName());
            if (jsonA != null && !jsonA.toString().equals("null")) return jsonA;
            JSON jsonB = (JSON)o.get("publisher");
            if (!jsonB.isArray()) return (JSONObject)jsonB;
            JSONArray arr = (JSONArray)jsonB;
            for (Object i : arr) {
                JSONObject ji = (JSONObject)i;
                if (!targetClass.equals(ji.get("stapler-class"))) continue;
                return ji;
            }
            return null;
        }

        public void doCheckConfig(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
            JSONObject json = this.getJSONClassObject(req.getSubmittedForm(), this.getId());
            if (json != null && !json.isNullObject()) {
                CoverityPublisher publisher = (CoverityPublisher)((Object)req.bindJSON(CoverityPublisher.class, json));
                CheckConfig ccs = new CheckConfig(publisher, null, null, null);
                ccs.check();
                req.setAttribute("descriptor", (Object)ccs.getDescriptor());
                req.setAttribute("instance", (Object)ccs);
                rsp.forward((Object)ccs.getDescriptor(), "checkConfig", req);
            }
        }

        public void doDefectFiltersConfig(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, CovRemoteServiceException_Exception {
            logger.info(req.getSubmittedForm().toString());
            JSONObject json = this.getJSONClassObject(req.getSubmittedForm(), this.getId());
            CIMStream.DescriptorImpl cimStreamDescriptor = null;
            if (json != null && !json.isNullObject()) {
                CoverityPublisher publisher = (CoverityPublisher)((Object)req.bindJSON(CoverityPublisher.class, json));
                CIMStream cimStream = publisher.getCimStream();
                if (cimStream != null) {
                    cimStreamDescriptor = (CIMStream.DescriptorImpl)cimStream.getDescriptor();
                }
                if (cimStreamDescriptor != null) {
                    if (!(StringUtils.isEmpty((String)cimStream.getInstance()) || StringUtils.isEmpty((String)cimStream.getProject()) || StringUtils.isEmpty((String)cimStream.getStream()))) {
                        CIMInstance instance = this.getInstance(publisher);
                        Object allCheckers = instance != null ? instance.getCimInstanceCheckers() : new ArrayList();
                        DefectFilters defectFilters = cimStream.getDefectFilters();
                        if (defectFilters != null) {
                            try {
                                cimStream.getDefectFilters().initializeFilter((List<String>)allCheckers, DescriptorImpl.toStrings(cimStreamDescriptor.doFillClassificationDefectFilterItems(cimStream.getInstance())), DescriptorImpl.toStrings(cimStreamDescriptor.doFillActionDefectFilterItems(cimStream.getInstance())), DescriptorImpl.toStrings(cimStreamDescriptor.doFillSeveritiesDefectFilterItems(cimStream.getInstance())), DescriptorImpl.toStrings(cimStreamDescriptor.doFillComponentDefectFilterItems(cimStream.getInstance(), cimStream.getStream())), DescriptorImpl.toStrings(cimStreamDescriptor.doFillImpactDefectFilterItems(cimStream.getInstance())));
                            }
                            catch (CovRemoteServiceException_Exception e) {
                                throw new IOException(e);
                            }
                        }
                    }
                    req.setAttribute("descriptor", (Object)cimStreamDescriptor);
                    req.setAttribute("instance", (Object)cimStream);
                }
            }
            rsp.forward(cimStreamDescriptor, "defectFilters", req);
        }

        @JavaScriptMethod
        public void doLoadProjectsForInstance(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
            CoverityPublisher publisher;
            CIMStream cimStream;
            JSONObject json = this.getJSONClassObject(req.getSubmittedForm(), this.getId());
            if (json != null && !json.isNullObject() && (cimStream = (publisher = (CoverityPublisher)((Object)req.bindJSON(CoverityPublisher.class, json))).getCimStream()) != null) {
                CIMInstance cimInstance = this.getInstance(publisher);
                ArrayList<String> projects = cimInstance != null ? new ArrayList<String>(CimCache.getInstance().getProjects(cimInstance)) : new ArrayList();
                String selectedProject = cimStream.getProject();
                boolean selectedProjectIsvalid = true;
                if (!StringUtils.isEmpty((String)selectedProject) && !projects.contains(selectedProject)) {
                    projects.add(selectedProject);
                    selectedProjectIsvalid = false;
                }
                rsp.setContentType("application/json; charset=utf-8");
                ServletOutputStream outputStream = rsp.getOutputStream();
                JSONObject responseObject = new JSONObject();
                responseObject.put("projects", projects);
                responseObject.put("selectedProject", (Object)selectedProject);
                responseObject.put("validSelection", (Object)selectedProjectIsvalid);
                String jsonString = responseObject.toString();
                outputStream.write(jsonString.getBytes("UTF-8"));
            }
        }

        @JavaScriptMethod
        public void doLoadStreamsForProject(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
            CoverityPublisher publisher;
            CIMStream cimStream;
            JSONObject json = this.getJSONClassObject(req.getSubmittedForm(), this.getId());
            if (json != null && !json.isNullObject() && (cimStream = (publisher = (CoverityPublisher)((Object)req.bindJSON(CoverityPublisher.class, json))).getCimStream()) != null) {
                CIMInstance cimInstance = this.getInstance(publisher);
                ArrayList<String> streams = cimInstance != null ? new ArrayList<String>(CimCache.getInstance().getStreams(cimInstance, cimStream.getProject())) : new ArrayList();
                String selectedStream = cimStream.getStream();
                boolean selectedStreamIsvalid = true;
                if (!StringUtils.isEmpty((String)selectedStream) && !streams.contains(selectedStream)) {
                    streams.add(selectedStream);
                    selectedStreamIsvalid = false;
                }
                rsp.setContentType("application/json; charset=utf-8");
                ServletOutputStream outputStream = rsp.getOutputStream();
                JSONObject responseObject = new JSONObject();
                responseObject.put("streams", streams);
                responseObject.put("selectedStream", (Object)selectedStream);
                responseObject.put("validSelection", (Object)selectedStreamIsvalid);
                String jsonString = responseObject.toString();
                outputStream.write(jsonString.getBytes("UTF-8"));
            }
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Jenkins context) {
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, new ArrayList()));
        }

        public FormValidation doCheckUser(@QueryParameter String user) {
            if (StringUtils.isEmpty((String)user)) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)"User is deprecated in Coverity plugin version 1.10 and later. Please use Credentials above for more secure username.");
        }

        public FormValidation doCheckPassword(@QueryParameter String password) {
            if (StringUtils.isEmpty((String)password)) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)"Password is deprecated in Coverity plugin version 1.10 and later. Please use Credentials above for more secure password.");
        }

        public FormValidation doCheckPostCovBuildCmd(@QueryParameter String postCovBuildCmd) {
            if (StringUtils.isEmpty((String)postCovBuildCmd)) {
                return FormValidation.error((String)"Post cov-build command cannot be empty!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPostCovAnalyzeCmd(@QueryParameter String postCovAnalyzeCmd) {
            if (StringUtils.isEmpty((String)postCovAnalyzeCmd)) {
                return FormValidation.error((String)"Post cov-analyze command cannot be empty!");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillToolInstallationNameItems() {
            ListBoxModel result = new ListBoxModel();
            for (CoverityToolInstallation toolInstallation : this.getInstallations()) {
                result.add(toolInstallation.getName());
            }
            return result;
        }
    }
}

