/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.coverity.CoverityBuildAction;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

public class CoverityProjectAction
implements Action {
    private final Job<?, ?> project;

    public CoverityProjectAction(Job<?, ?> project) {
        this.project = project;
    }

    public Job<?, ?> getProject() {
        return this.project;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "coverity";
    }

    public Graph getGraph() {
        return new GraphImpl();
    }

    private static class ChartLabel
    implements Comparable<ChartLabel> {
        private Run build;

        public ChartLabel(Run build) {
            this.build = build;
        }

        public String getUrl() {
            return Jenkins.getInstance().getRootUrl() + this.build.getUrl();
        }

        @Override
        public int compareTo(ChartLabel that) {
            return this.build.number - that.build.number;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChartLabel)) {
                return false;
            }
            ChartLabel that = (ChartLabel)o;
            return this.build == that.build;
        }

        public Color getColor() {
            return null;
        }

        public int hashCode() {
            return this.build.getDisplayName().hashCode();
        }

        public String toString() {
            String s;
            String l = this.build.getDisplayName();
            if (this.build instanceof AbstractBuild && (s = ((AbstractBuild)this.build).getBuiltOnStr()) != null) {
                l = l + ' ' + s;
            }
            return l;
        }
    }

    private static class ChartItemRenderer
    extends StackedAreaRenderer2 {
        private final CategoryDataset ds;

        public ChartItemRenderer(CategoryDataset ds) {
            this.ds = ds;
        }

        public Paint getItemPaint(int row, int column) {
            ChartLabel key = (ChartLabel)this.ds.getColumnKey(column);
            if (key.getColor() != null) {
                return key.getColor();
            }
            return super.getItemPaint(row, column);
        }

        public String generateURL(CategoryDataset dataset, int row, int column) {
            ChartLabel label = (ChartLabel)dataset.getColumnKey(column);
            return label.getUrl() + "coverity_defects";
        }

        public String generateToolTip(CategoryDataset dataset, int row, int column) {
            ChartLabel label = (ChartLabel)dataset.getColumnKey(column);
            int defects = 0;
            for (CoverityBuildAction a : label.build.getActions(CoverityBuildAction.class)) {
                defects += a.getDefects().size();
            }
            return label.build.getDisplayName() + " has " + defects + " total defects";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ChartItemRenderer)) {
                return false;
            }
            ChartItemRenderer that = (ChartItemRenderer)((Object)obj);
            return this.ds != that.ds ? false : super.equals(obj);
        }

        public int hashCode() {
            int result = this.ds.hashCode();
            result = 31 * result + super.hashCode();
            return result;
        }
    }

    private class GraphImpl
    extends Graph {
        protected GraphImpl() {
            super(-1L, 600, 300);
        }

        protected DataSetBuilder<String, ChartLabel> createDataSet() {
            DataSetBuilder data = new DataSetBuilder();
            for (Run build = CoverityProjectAction.this.project.getLastCompletedBuild(); build != null; build = build.getPreviousBuild()) {
                List actions = build.getActions(CoverityBuildAction.class);
                for (CoverityBuildAction action : actions) {
                    if (action == null || action.getDefects() == null || action.getGraphDisplayName() == null) continue;
                    data.add((Number)action.getDefects().size(), (Comparable)((Object)action.getGraphDisplayName()), (Comparable)new ChartLabel(build));
                }
            }
            return data;
        }

        protected JFreeChart createGraph() {
            CategoryDataset dataset = this.createDataSet().build();
            List rows = dataset.getColumnKeys();
            for (int i = 0; i < rows.size(); ++i) {
                Object row = rows.get(i);
                if (row != null) continue;
                throw new NullPointerException();
            }
            JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"Defect Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setBackgroundPaint((Paint)Color.white);
            plot.setOutlinePaint(null);
            plot.setForegroundAlpha(0.8f);
            plot.setDomainGridlinesVisible(true);
            plot.setDomainGridlinePaint((Paint)Color.white);
            plot.setRangeGridlinesVisible(true);
            plot.setRangeGridlinePaint((Paint)Color.black);
            ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
            plot.setDomainAxis((CategoryAxis)domainAxis);
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            domainAxis.setLowerMargin(0.0);
            domainAxis.setUpperMargin(0.0);
            domainAxis.setCategoryMargin(0.0);
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            rangeAxis.setAutoRange(true);
            plot.setRenderer((CategoryItemRenderer)new ChartItemRenderer(dataset));
            plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
            return chart;
        }
    }
}

