/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.Extension;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Queue;
import jenkins.plugins.coverity.CoverityLauncher;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.InvocationAssistance;
import jenkins.plugins.coverity.ScmOptionBlock;
import jenkins.plugins.coverity.TaOptionBlock;

@Extension
public class CoverityLauncherDecorator
extends LauncherDecorator {
    public static ThreadLocal<Boolean> CoverityPostBuildAction = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    public static ThreadLocal<Boolean> CoverityBuildStep = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public Launcher decorate(Launcher launcher, Node node) {
        String scmCheck;
        String taCheck;
        Executor executor = Executor.currentExecutor();
        if (executor == null) {
            return launcher;
        }
        Queue.Executable exec = executor.getCurrentExecutable();
        if (!(exec instanceof AbstractBuild)) {
            return launcher;
        }
        AbstractBuild build = (AbstractBuild)exec;
        AbstractProject project = build.getProject();
        CoverityPublisher publisher = (CoverityPublisher)project.getPublishersList().get(CoverityPublisher.class);
        if (publisher == null) {
            return launcher;
        }
        TaOptionBlock ta = publisher.getTaOptionBlock();
        ScmOptionBlock scm = publisher.getScmOptionBlock();
        InvocationAssistance invocationAssistance = publisher.getInvocationAssistance();
        boolean isUsingTA = false;
        boolean isUsingMisra = false;
        if (ta != null) {
            taCheck = ta.checkTaConfig();
            if (!taCheck.equals("Pass")) {
                throw new RuntimeException(taCheck);
            }
            isUsingTA = true;
        }
        if (invocationAssistance != null) {
            taCheck = invocationAssistance.checkIAConfig();
            if (!taCheck.equals("Pass")) {
                throw new RuntimeException(taCheck);
            }
            isUsingMisra = invocationAssistance.getIsUsingMisra();
        }
        if (isUsingTA && isUsingMisra) {
            String errorText = "Errors with your \"Perform Coverity build/analyze/commit\" options: \n [Error] MISRA and Test Advisor options are not compatible. \n";
            throw new RuntimeException(errorText);
        }
        if (scm != null && !(scmCheck = scm.checkScmConfig()).equals("Pass")) {
            throw new RuntimeException(scmCheck);
        }
        return new CoverityLauncher(launcher, node);
    }
}

