/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Node;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.plugins.coverity.CoverityBuildStep;
import jenkins.plugins.coverity.CoverityLauncherDecorator;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTempDir;
import jenkins.plugins.coverity.CoverityTool.CovBuildCompileCommand;
import jenkins.plugins.coverity.CoverityToolInstallation;
import jenkins.plugins.coverity.CoverityUtils;
import jenkins.plugins.coverity.EnvParser;
import jenkins.plugins.coverity.InvocationAssistance;
import jenkins.plugins.coverity.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class CoverityLauncher
extends Launcher {
    private static final Logger logger = Logger.getLogger(CoverityLauncherDecorator.class.getName());
    private final Launcher decorated;
    private String[] prefix;
    private final String toolsDir;
    private final Node node;
    private EnvVars envVars;

    public CoverityLauncher(Launcher decorated, Node node) {
        super(decorated);
        this.decorated = decorated;
        this.node = node;
        this.toolsDir = node.getRootPath().child("tools").getRemote();
    }

    private String[] getPrefix() {
        String[] tp = (String[])this.prefix.clone();
        if (tp.length > 0) {
            tp[0] = CoverityUtils.getCovBuild(this.decorated.getListener(), this.node);
        }
        return tp;
    }

    public Proc launch(Launcher.ProcStarter starter) throws IOException {
        EnvVars buildEnvVars = CoverityUtils.getBuildEnvVars(this.listener);
        if (this.envVars == null || this.envVars.isEmpty()) {
            this.envVars = buildEnvVars;
        } else if (buildEnvVars != null) {
            this.envVars.overrideAll((Map)buildEnvVars);
        }
        AbstractBuild build = CoverityUtils.getBuild();
        AbstractProject project = build.getProject();
        CoverityPublisher publisher = (CoverityPublisher)project.getPublishersList().get(CoverityPublisher.class);
        if (publisher == null) {
            return this.decorated.launch(starter);
        }
        this.setupIntermediateDirectory(build, this.getListener(), this.node);
        if (CoverityLauncherDecorator.CoverityPostBuildAction.get().booleanValue()) {
            String[] starterEnvVars = starter.envs();
            starterEnvVars = CoverityUtils.addEnvVars(starterEnvVars, this.envVars);
            starter = starter.envs(starterEnvVars);
            return this.decorated.launch(starter);
        }
        boolean isCoverityBuildStepEnabled = false;
        if (project instanceof Project) {
            List builders = ((Project)project).getBuilders();
            for (Builder buildStep : builders) {
                if (!(buildStep.getDescriptor() instanceof CoverityBuildStep.CoverityBuildStepDescriptor)) continue;
                isCoverityBuildStepEnabled = true;
                break;
            }
        }
        if (!isCoverityBuildStepEnabled || isCoverityBuildStepEnabled && CoverityLauncherDecorator.CoverityBuildStep.get().booleanValue()) {
            String lastArg;
            List<String> cmds = starter.cmds();
            InvocationAssistance invocationAssistance = CoverityUtils.getInvocationAssistance();
            CoverityToolInstallation installation = CoverityUtils.findToolInstallationForBuild(this.node, this.envVars, this.getListener());
            if (installation != null) {
                String home = installation.getHome();
                if (invocationAssistance != null) {
                    List<String> args = new CovBuildCompileCommand(build, this.decorated, this.decorated.getListener(), publisher, home, this.envVars).constructArguments();
                    this.prefix = args.toArray(new String[args.size()]);
                    cmds.addAll(0, args);
                } else {
                    this.prefix = new String[0];
                }
            }
            boolean useAdvancedParser = false;
            if (invocationAssistance != null && invocationAssistance.getUseAdvancedParser()) {
                useAdvancedParser = true;
            }
            if ((lastArg = (String)cmds.get(cmds.size() - 1)).startsWith(this.toolsDir) && lastArg.endsWith(".sh")) {
                logger.info(lastArg + " is a tools script, skipping cov-build");
                return this.decorated.launch(starter);
            }
            String[] starterEnvVars = starter.envs();
            starterEnvVars = CoverityUtils.addEnvVars(starterEnvVars, this.envVars);
            starter = starter.envs(starterEnvVars);
            boolean[] masks = (starter = starter.cmds(cmds = CoverityUtils.prepareCmds(cmds, this.envVars, useAdvancedParser))).masks();
            if (masks == null) {
                masks = new boolean[cmds.size()];
                starter = starter.masks(masks);
            } else {
                starter = starter.masks(this.prefix(masks));
            }
            CoverityLauncherDecorator.CoverityBuildStep.set(false);
        }
        return this.decorated.launch(starter);
    }

    public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
        String lastArg = cmd[cmd.length - 1];
        if (lastArg.startsWith(this.toolsDir) && lastArg.endsWith(".sh")) {
            logger.info(lastArg + " is a tools script, skipping cov-build");
            this.decorated.launchChannel(cmd, out, workDir, envVars);
        }
        return this.decorated.launchChannel(this.prefix(cmd), out, workDir, envVars);
    }

    public boolean isUnix() {
        return this.decorated.isUnix();
    }

    public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
        this.decorated.kill(modelEnvVars);
    }

    private String[] prefix(String[] args) {
        String[] newArgs = new String[args.length + this.prefix.length];
        System.arraycopy(this.getPrefix(), 0, newArgs, 0, this.prefix.length);
        System.arraycopy(args, 0, newArgs, this.prefix.length, args.length);
        return newArgs;
    }

    private boolean[] prefix(boolean[] args) {
        boolean[] newArgs = new boolean[args.length + this.prefix.length];
        System.arraycopy(args, 0, newArgs, this.prefix.length, args.length);
        return newArgs;
    }

    public void setupIntermediateDirectory(@Nonnull AbstractBuild<?, ?> build, @Nonnull TaskListener listener, @Nonnull Node node) {
        Validate.notNull(build, (String)(AbstractBuild.class.getName() + " object can't be null"));
        Validate.notNull((Object)listener, (String)(TaskListener.class.getName() + " object can't be null"));
        Validate.notNull((Object)node, (String)(Node.class.getName() + " object can't be null"));
        Validate.notNull((Object)this.envVars, (String)(EnvVars.class.getName() + " object can't be null"));
        if (!this.envVars.containsKey((Object)"COV_IDIR")) {
            FilePath temp = null;
            InvocationAssistance invocationAssistance = CoverityUtils.getInvocationAssistance(build);
            try {
                if (invocationAssistance == null || invocationAssistance.getIntermediateDir() == null || invocationAssistance.getIntermediateDir().isEmpty()) {
                    FilePath coverityDir = node.getRootPath().child("coverity");
                    coverityDir.mkdirs();
                    temp = coverityDir.createTempDir("temp-", null);
                } else {
                    String customIdir = EnvParser.interpolateRecursively(invocationAssistance.getIntermediateDir(), 1, this.envVars);
                    if (customIdir == null || customIdir.isEmpty()) {
                        throw new Exception("The specified Intermediate Directory is not valid: " + invocationAssistance.getIntermediateDir());
                    }
                    File idir = new File(customIdir);
                    String workspace = (String)this.envVars.get((Object)"WORKSPACE");
                    if (idir != null && !idir.isAbsolute() && StringUtils.isNotEmpty((String)workspace) && StringUtils.isNotEmpty((String)(customIdir = FilenameUtils.concat((String)workspace, (String)customIdir)))) {
                        customIdir = node.toComputer().isUnix() != false ? customIdir.replace("\\", "/") : customIdir.replace("/", "\\");
                    }
                    if (StringUtils.isNotEmpty((String)customIdir)) {
                        temp = new FilePath(node.getChannel(), customIdir);
                        temp.mkdirs();
                    }
                }
                if (invocationAssistance != null) {
                    build.addAction((Action)new CoverityTempDir(temp, invocationAssistance.getIntermediateDir() == null));
                } else {
                    build.addAction((Action)new CoverityTempDir(temp, true));
                }
            }
            catch (IOException e) {
                CoverityUtils.handleException("Error while creating temporary directory for Coverity", build, listener, (Exception)e);
            }
            catch (InterruptedException e) {
                CoverityUtils.handleException("Interrupted while creating temporary directory for Coverity", build, listener, (Exception)e);
            }
            catch (ParseException e) {
                CoverityUtils.handleException(e.getMessage(), build, listener, (Exception)e);
            }
            catch (Exception e) {
                if (temp != null) {
                    CoverityUtils.handleException("An error occurred while setting intermediate directory: " + temp.getRemote(), build, listener, e);
                }
                CoverityUtils.handleException("An error occurred while setting intermediate directory", build, listener, e);
            }
            if (temp != null) {
                this.envVars.put("COV_IDIR", temp.getRemote());
            }
        }
    }
}

