/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.plugins.coverity.CoverityToolInstallation;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class CoverityEnvBuildWrapper
extends SimpleBuildWrapper {
    private final String coverityToolName;

    @DataBoundConstructor
    public CoverityEnvBuildWrapper(String coverityToolName) {
        this.coverityToolName = coverityToolName;
    }

    public String getCoverityToolName() {
        return this.coverityToolName;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        CoverityToolInstallation covTools = this.getCoverityToolInstallation();
        if (covTools == null) {
            throw new IOException("Unable to find Coverity tools installation: [" + this.coverityToolName + "]. Please configure one for this Jenkins instance.");
        }
        Computer computer = workspace.toComputer();
        if (computer == null) {
            throw new AbortException("Cannot get Coverity tools installation");
        }
        Node node = computer.getNode();
        if (node == null) {
            throw new AbortException("Cannot get Coverity tools installation");
        }
        covTools = covTools.translate(node, initialEnvironment, listener);
        EnvVars covEnvVars = new EnvVars();
        covTools.buildEnvVars(covEnvVars);
        for (Map.Entry entry : covEnvVars.entrySet()) {
            context.env((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public CoverityToolInstallation getCoverityToolInstallation() {
        DescriptorImpl descriptor = this.getDescriptor();
        if (this.getDescriptor() != null && this.coverityToolName != null) {
            for (CoverityToolInstallation toolInstallation : descriptor.getInstallations()) {
                if (!this.coverityToolName.equalsIgnoreCase(toolInstallation.getName())) continue;
                return toolInstallation;
            }
        }
        return null;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"withCoverityEnv"})
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Provide Coverity Tools bin/ directory to PATH";
        }

        public ListBoxModel doFillCoverityToolNameItems() {
            ListBoxModel result = new ListBoxModel();
            for (CoverityToolInstallation toolInstallation : this.getInstallations()) {
                result.add(toolInstallation.getName());
            }
            return result;
        }

        public CoverityToolInstallation[] getInstallations() {
            CoverityToolInstallation.CoverityToolInstallationDescriptor descriptor = (CoverityToolInstallation.CoverityToolInstallationDescriptor)Jenkins.getInstance().getDescriptorByType(CoverityToolInstallation.CoverityToolInstallationDescriptor.class);
            return descriptor.getInstallations();
        }
    }
}

