/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.coverity.CoverityLauncherDecorator;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

public class CoverityBuildStep
extends Builder {
    private final BuildStep buildStep;

    @DataBoundConstructor
    public CoverityBuildStep(BuildStep buildStep) {
        this.buildStep = buildStep;
    }

    public BuildStep getBuildStep() {
        return this.buildStep;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        CoverityLauncherDecorator.CoverityBuildStep.set(true);
        return this.buildStep.perform(build, launcher, listener);
    }

    @Extension
    public static class CoverityBuildStepDescriptor
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return Project.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Invoke Coverity Capture Build";
        }

        public List<? extends Descriptor<? extends BuildStep>> getAllowedBuilders(AbstractProject<?, ?> project) {
            if (project == null) {
                project = (AbstractProject)Stapler.getCurrentRequest().findAncestorObject(AbstractProject.class);
            }
            ArrayList<BuildStepDescriptor> builders = new ArrayList<BuildStepDescriptor>();
            if (project == null) {
                return builders;
            }
            for (Descriptor descriptor : Builder.all()) {
                BuildStepDescriptor buildStepDescriptor;
                if (!(descriptor instanceof BuildStepDescriptor) || descriptor instanceof CoverityBuildStepDescriptor || !(buildStepDescriptor = (BuildStepDescriptor)descriptor).isApplicable(project.getClass())) continue;
                builders.add(buildStepDescriptor);
            }
            return builders;
        }
    }
}

